package cn.lsmya.helper.activity

import android.graphics.PorterDuff
import android.view.Menu
import android.view.MenuItem
import androidx.annotation.DrawableRes
import cn.lsmya.helper.ToolsHelper
import cn.lsmya.helper.ToolsHelper.Companion.getContext

open class BaseToolBarActivity : BaseActivity() {

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, onClickListener: MenuItem.OnMenuItemClickListener) {
        val menuItem = getToolbar().menu.add(addColor(text, ToolsHelper.getTitleTextColor()))
        menuItem.setOnMenuItemClickListener(onClickListener)
        menuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS)
    }

    /**
     * 修改菜单按钮的文字内容
     */
    fun changeMenuItemTextView(text: String, item: MenuItem) {
        changeMenuItemTextView(text, item, ToolsHelper.getTitleTextColor())
    }

    fun changeMenuItemTextView(text: String, item: MenuItem, color: Int) {
        item.title = addColor(text, color)
    }

    /**
     * 添加一个图标菜单按钮
     */
    fun addMenuItemImageView(@DrawableRes resId: Int, onClickListener: MenuItem.OnMenuItemClickListener) {
        val menuItem = getToolbar().menu.add("")
        menuItem.setIcon(resId)
        menuItem.setOnMenuItemClickListener(onClickListener)
        menuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS)
        menuItem.icon.setColorFilter(ToolsHelper.getTitleTextColor(), PorterDuff.Mode.SRC_ATOP)
    }




    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        val itemId = item!!.itemId
        if (itemId == android.R.id.home) {
            setNavigationIconClick()
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onMenuOpened(featureId: Int, menu: Menu?): Boolean {
        if (menu != null) {
            if (menu.javaClass.simpleName == "MenuBuilder") {
                try {
                    val method = menu.javaClass
                        .getDeclaredMethod("setOptionalIconsVisible", java.lang.Boolean.TYPE)
                    method.isAccessible = true
                    method.invoke(menu, true)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
        return super.onMenuOpened(featureId, menu)
    }

    private fun getStatusHeight(): Int {
        var statusHeight = -1
        try {
            val clazz = Class.forName("com.android.internal.R\$dimen")
            val `object` = clazz.newInstance()
            val id = clazz.getField("status_bar_height")[`object`] as Int
            statusHeight = getContext().resources.getDimensionPixelSize(id)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
        return statusHeight
    }

}