package cn.lsmya.helper.activity

import android.graphics.drawable.Drawable
import android.os.Bundle
import android.view.Gravity
import androidx.appcompat.app.AppCompatActivity
import com.google.android.material.bottomnavigation.BottomNavigationItemView
import com.google.android.material.bottomnavigation.BottomNavigationMenuView
import com.google.android.material.bottomnavigation.BottomNavigationView
import cn.lsmya.helper.badgeview.Badge
import cn.lsmya.helper.badgeview.QBadgeView

abstract class BaseBottomBarActivity : AppCompatActivity() {

    abstract fun getLayout(): Int

    abstract fun getMenuLayout(): Int

    abstract fun getBottomNavigationView(): BottomNavigationView

    private lateinit var list: ArrayList<Badge>

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(getLayout())
        list = ArrayList()
        getBottomNavigationView().inflateMenu(getMenuLayout())
        getBottomNavigationView().setOnNavigationItemSelectedListener { p0 ->
            onItemSelectListener(p0.itemId)
            false
        }
        addBadgeView()
    }

    private fun addBadgeView() {
        list.clear()
        val navigationMenuView = getBottomNavigationView().getChildAt(0) as BottomNavigationMenuView
        val childCount = navigationMenuView.childCount
        for (index in 0..childCount) {
            val childAt = navigationMenuView.getChildAt(index)
            if (childAt != null) {
                val bottomNavigationItemView = childAt as BottomNavigationItemView
                list.add(
                    QBadgeView(this)
                        .bindTarget(bottomNavigationItemView)
                        .setBadgeNumber(0)
                        .setBadgeGravity(Gravity.END or Gravity.TOP)
                        .setGravityOffset(40f, 0f, true)
                        .setBadgeTextSize(10f, true)
                )
            }
        }
    }

    open fun onItemSelectListener(itemId: Int) {

    }

    /**
     * 设置Badge数字
     */
    fun setBadgeNumber(position: Int, number: Int) {
        list[position].badgeNumber = number
    }

    /**
     * 设置Badge文本
     */
    fun setBadgeText(position: Int, text: String) {
        list[position].badgeText = text
    }

    /**
     * 设置文本字体大小
     */
    fun setBadgeTextSize(size: Float) {
        for (badge in list) {
            badge.setBadgeTextSize(size, true)
        }
    }

    /**
     * 设置文本颜色
     */
    fun setBadgeTextColor(color: Int) {
        for (badge in list) {
            badge.badgeTextColor = color
        }
    }

    /**
     * 设置是否显示精确模式数值
     * true：999 -> 999
     * false：999 -> 99+
     */
    fun setExactMode(isExact: Boolean) {
        for (badge in list) {
            badge.isExactMode = isExact
        }
    }

    /**
     * 设置Badge相对于TargetView的位置
     */
    fun setBadgeGravity(gravity: Int) {
        for (badge in list) {
            badge.badgeGravity = gravity
        }
    }

    /**
     * 设置外边距
     */
    fun setGravityOffset(x: Float, y: Float) {
        for (badge in list) {
            badge.setGravityOffset(x, y, true)
        }
    }

    /**
     * 设置内边距
     */
    fun setBadgePadding(padding: Float) {
        for (badge in list) {
            badge.setBadgePadding(padding, true)
        }
    }

    /**
     * 设置背景色
     */
    fun setBadgeBackgroundColor(color: Int) {
        for (badge in list) {
            badge.badgeBackgroundColor = color
        }
    }

    /**
     * 设置背景图片
     */
    fun setBadgeBackground(drawable: Drawable) {
        for (badge in list) {
            badge.badgeBackground = drawable
        }
    }

    /**
     * 设置是否显示阴影
     */
    fun setShowShadow(showShadow: Boolean) {
        for (badge in list) {
            badge.isShowShadow = showShadow
        }
    }

    /**
     * 打开拖拽消除模式并设置监听
     */
    fun setOnDragStateChangedListener(listener: Badge.OnDragStateChangedListener) {
        for (badge in list) {
            badge.setOnDragStateChangedListener(listener)
        }
    }

    /**
     * 隐藏Badge
     */
    fun hide(position: Int, animate: Boolean) {
        list[position].hide(animate)
    }

}
