package cn.lsmya.helper.util

import android.content.Context
import android.content.SharedPreferences
import cn.lsmya.helper.ToolsHelper
import com.alibaba.fastjson.JSON

class SpHelper {

    companion object {
        private const val defaultName: String = "default_sp_Name"
        private const val spName: String = "spNameList"

        private var mEncode = false

        @JvmStatic
        fun openEncode(encode: Boolean) {
            mEncode = encode
        }

        @JvmStatic
        fun put(key: String, value: Any?) {
            put(
                defaultName,
                key,
                value,
                false
            )
        }

        @JvmStatic
        fun put(key: String, value: Any?, isCommit: Boolean) {
            put(
                defaultName,
                key,
                value,
                isCommit
            )
        }

        @JvmStatic
        fun put(name: String, key: String, value: Any?) {
            put(
                name,
                key,
                value,
                false
            )
        }

        @JvmStatic
        fun put(name: String, key: String, value: Any?, isCommit: Boolean) {
            if (value == null) {
                return
            }
            setSharedPreferencesList(name)
            val edit = getSharedPreferences(name).edit()
            var editor: SharedPreferences.Editor? = null
            when (value) {
                is String -> {
                    editor = edit.putString(
                        getEncodeWord(
                            key
                        ),
                        getEncodeWord(
                            value
                        )
                    )
                }
                is Int -> {
                    editor = edit.putInt(
                        getEncodeWord(
                            key
                        ), value
                    )
                }
                is Long -> {
                    editor = edit.putLong(
                        getEncodeWord(
                            key
                        ), value
                    )
                }
                is Float -> {
                    editor = edit.putFloat(
                        getEncodeWord(
                            key
                        ), value
                    )
                }
                is Boolean -> {
                    editor = edit.putBoolean(
                        getEncodeWord(
                            key
                        ), value
                    )
                }
            }
            if (editor != null) {
                if (isCommit) {
                    editor.commit()
                } else {
                    editor.apply()
                }
            }
        }

        @JvmStatic
        fun getString(key: String, defaultValue: String): String {
            return getString(
                defaultName,
                key,
                defaultValue
            )
        }

        @JvmStatic
        fun getString(name: String, key: String, defaultValue: String): String {
            val defaultString =
                getSharedPreferences(
                    name
                )
                    .getString(
                        getEncodeWord(
                            key
                        ),
                        defaultValue
                    )
            return if (defaultString == defaultValue) {
                defaultString
            } else {
                getDecodeWord(
                    defaultString
                )
            }
        }

        @JvmStatic
        fun getInt(key: String, defaultValue: Int): Int {
            return getInt(
                defaultName,
                key,
                defaultValue
            )
        }

        @JvmStatic
        fun getInt(name: String, key: String, defaultValue: Int): Int {
            return getSharedPreferences(
                name
            )
                .getInt(
                    getEncodeWord(
                        key
                    ),
                    defaultValue
                )
        }

        @JvmStatic
        fun getLong(key: String, defaultValue: Long?): Long? {
            return getLong(
                defaultName,
                key,
                defaultValue
            )
        }

        @JvmStatic
        fun getLong(name: String, key: String, defaultValue: Long?): Long? {
            return getSharedPreferences(
                name
            ).getLong(
                getEncodeWord(
                    key
                ),
                defaultValue!!
            )
        }

        @JvmStatic
        fun getBoolean(key: String, defaultValue: Boolean): Boolean? {
            return getBoolean(
                defaultName,
                key,
                defaultValue
            )
        }

        @JvmStatic
        fun getBoolean(name: String, key: String, defaultValue: Boolean): Boolean? {
            return getSharedPreferences(
                getEncodeWord(
                    name
                )
            ).getBoolean(
                getEncodeWord(
                    key
                ),
                defaultValue
            )
        }

        @JvmStatic
        fun getFloat(key: String, defaultValue: Float): Float? {
            return getFloat(
                defaultName,
                key,
                defaultValue
            )
        }

        @JvmStatic
        fun getFloat(name: String, key: String, defaultValue: Float): Float? {
            return getSharedPreferences(
                name
            ).getFloat(
                getEncodeWord(
                    key
                ),
                defaultValue
            )
        }

        /**
         * 清除数据
         */
        @JvmStatic
        fun removeDefault(key: String) {
            remove(
                defaultName,
                key,
                false
            )
        }

        @JvmStatic
        fun remove(name: String, key: String) {
            remove(
                name,
                key,
                false
            )
        }

        @JvmStatic
        fun clearDefault() {
            clear(
                defaultName,
                false
            )
        }

        @JvmStatic
        fun clear(name: String) {
            clear(
                name,
                false
            )
        }

        @JvmStatic
        fun clearAll() {
            clearAll(false)
        }

        @JvmStatic
        fun clearAll(isCommit: Boolean) {
            val list = JSON.parseArray(
                getSharedPreferences(
                    spName
                ).getString("nameList", "[]"),
                String::class.java
            )
            list?.forEach {
                clear(
                    it,
                    isCommit
                )
            }
        }

        @JvmStatic
        fun remove(name: String, key: String, isCommit: Boolean) {
            if (isCommit) {
                getSharedPreferences(
                    name
                ).edit().remove(
                    getEncodeWord(
                        key
                    )
                ).commit()
            } else {
                getSharedPreferences(
                    name
                ).edit().remove(
                    getEncodeWord(
                        key
                    )
                ).apply()
            }
        }

        @JvmStatic
        fun clear(name: String, isCommit: Boolean) {
            if (isCommit) {
                getSharedPreferences(
                    name
                ).edit().clear().commit()
            } else {
                getSharedPreferences(
                    name
                ).edit().clear().apply()
            }
        }

        private fun getSharedPreferences(name: String): SharedPreferences {
            return ToolsHelper.getContext().getSharedPreferences(name, Context.MODE_PRIVATE)
        }

        private fun getEncodeWord(value: String): String = if (mEncode) {
            Base64Helper.encodeWord(value)
        } else {
            value
        }

        private fun getDecodeWord(value: String): String = if (mEncode) {
            Base64Helper.decodeWord(value)
        } else {
            value
        }

        private fun setSharedPreferencesList(name: String) {
            val arrayList =
                getSharedPreferencesList()
            if (!arrayList.contains(name)) {
                clear(
                    spName,
                    true
                )
                arrayList.add(name)
                val jsonString = JSON.toJSONString(arrayList)
                getSharedPreferences(
                    spName
                ).edit().putString("nameList", jsonString).apply()
            }
        }

        private fun getSharedPreferencesList(): ArrayList<String> {
            val arrayList = ArrayList<String>()
            arrayList.addAll(
                JSON.parseArray(
                    getSharedPreferences(
                        spName
                    ).getString("nameList", "[]"),
                    String::class.java
                )
            )
            return arrayList
        }
    }
}