package cn.lsmya.helper.util

import android.util.Log
import cn.lsmya.helper.ToolsHelper

/**
 * 日志工具类
 */
class LogHelper private constructor() {
    companion object {
        private const val mTag = "【 LOG 】"

        @JvmStatic
        fun d(msg: String) {
            d(
                mTag,
                msg
            )
        }

        @JvmStatic
        fun e(msg: String) {
            e(
                mTag,
                msg
            )
        }

        @JvmStatic
        fun i(msg: String) {
            i(
                mTag,
                msg
            )
        }

        @JvmStatic
        fun v(msg: String) {
            v(
                mTag,
                msg
            )
        }

        @JvmStatic
        fun d(tag: String, msg: String) {
            if (ToolsHelper.debug()) {
                Log.d(tag, msg)
            }
        }

        @JvmStatic
        fun e(tag: String, msg: String) {
            if (ToolsHelper.debug()) {
                Log.e(tag, msg)
            }
        }

        @JvmStatic
        fun i(tag: String, msg: String) {
            if (ToolsHelper.debug()) {
                Log.i(tag, msg)
            }
        }

        @JvmStatic
        fun v(tag: String, msg: String) {
            if (ToolsHelper.debug()) {
                Log.v(tag, msg)
            }
        }

    }
}