package cn.lsmya.helper.mvp;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import cn.lsmya.helper.fragment.LazyFragment;
import cn.lsmya.helper.util.ToastHelper;

public abstract class BaseMvpFragment<P extends BaseMvpPresenter> extends LazyFragment {

    private P mPresenter;

    public abstract void attachView();

    public void setPresenter(P presenter) {
        mPresenter = presenter;
    }

    public P getPresenter() {
        return mPresenter;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        attachView();
        findView();
        initView();
    }

    /**
     * 绑定控件
     */
    protected void findView() {

    }

    /**
     * 初始化控件
     */
    protected abstract void initView();

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (getPresenter()  != null) {
            getPresenter() .detachView();
        }
    }

    public void showToast(String text) {
        ToastHelper.showText(text);
    }

    public void showToastSuccess(String text) {
        ToastHelper.showSuccess(text);
    }

    public void showToastError(String text) {
        ToastHelper.showError(text);
    }
}
