package cn.lsmya.helper.util;

import android.content.Context;

public class ResourceHelper {

    public static int getDrawableIdByName(Context context, String idName) {
        return getResourceIdByName(context, "drawable", idName);
    }

    public static int getLayoutIdByName(Context context, String idName) {
        return getResourceIdByName(context, "layout", idName);
    }

    public static int getStringIdByName(Context context, String idName) {
        return getResourceIdByName(context, "string", idName);
    }

    public static int getStyleIdByName(Context context, String idName) {
        return getResourceIdByName(context, "style", idName);
    }

    public static int getColorIdByName(Context context, String idName) {
        return getResourceIdByName(context, "color", idName);
    }

    public static int getArrayIdByName(Context context, String idName) {
        return getResourceIdByName(context, "array", idName);
    }

    public static int getResourceIdByName(Context context, String className, String idName) {
        int id = -1;
        try {
            Class<?> cls = Class.forName(context.getPackageName()
                    + ".R$" + className);
            id = cls.getField(idName).getInt(cls);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

}
