package cn.lsmya.helper.picker;

import android.os.Bundle;
import android.view.MenuItem;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.helper.R;
import cn.lsmya.helper.recyclerview.BaseViewAdapter;
import cn.lsmya.helper.recyclerview.BaseViewHolder;
import cn.lsmya.helper.recyclerview.RxRecyclerViewPageChangeListener;

public class ImageBigActivity extends AppCompatActivity implements BaseViewAdapter.OnItemClickListener {

    private RecyclerView recyclerView;
    private BaseViewAdapter<String> adapter;
    private List<String> list;
    private RequestOptions options;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.kit_activity_image_big);
        setTitle(getString(R.string.kit_look_big));
        list = new ArrayList<>();
        options = new RequestOptions()
                .fitCenter()
                .skipMemoryCache(true)
                .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
        ActionBar supportActionBar = getSupportActionBar();
        supportActionBar.setDisplayHomeAsUpEnabled(true);
        recyclerView = findViewById(R.id.kit_imageBig_recyclerView);
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this);
        linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        recyclerView.setLayoutManager(linearLayoutManager);
        adapter = new BaseViewAdapter<String>(list, R.layout.kit_photo_gallery_item) {
            @Override
            public void onBind(String bean, int position, BaseViewHolder ho) {
                Glide.with(getContext()).load(bean)
                        .thumbnail(0.1f)
                        .apply(options)
                        .into(ho.getImageView(R.id.kit_photoGalleryItem_image));
            }
        };
        recyclerView.setAdapter(adapter);
        adapter.setOnItemClickListener(this);
        PagerSnapHelper snapHelper = new PagerSnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        recyclerView.addOnScrollListener(new RxRecyclerViewPageChangeListener(snapHelper, new RxRecyclerViewPageChangeListener.OnPageChangeListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {

            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {

            }

            @Override
            public void onPageSelected(int pos) {
                if (list.size() != 1) {
                    setTitle(String.format(getString(R.string.kit_look_big_num), pos + 1, list.size()));
                }
            }
        }));
        ArrayList<String> strings = getIntent().getStringArrayListExtra("list");
        if (strings != null && strings.size() != 0) {
            list.clear();
            list.addAll(strings);
            adapter.notifyDataSetChanged();
            if (list.size() != 1) {
                setTitle(String.format(getString(R.string.kit_look_big_num), 1, list.size()));

            }
        }
    }

    @Override
    public void onItemClick(int position) {
        finish();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                finish();
                break;
            default:
                break;
        }
        return super.onOptionsItemSelected(item);

    }
}
