package cn.lsmya.helper.mvp;

/**
 * @author lsm
 */
public abstract class BaseMvpPresenter<V> {
    /**
     * View接口
     */
    private V mView;

    /**
     * 绑定view，一般在初始化中调用该方法
     */
    public void attachView(V mvpView) {
        this.mView = mvpView;
    }

    /**
     * 断开view，一般在onDestroy中调用
     */
    public void detachView() {
        this.mView = null;
    }

    /**
     * 是否与View建立连接
     * 每次调用业务请求的时候都要出先调用方法检查是否与View建立连接
     */
    public boolean isViewAttached() {
        return mView != null;
    }

    public V getMvpView() {
        return mView;
    }

    public abstract void onBefore(String url, String method);

    public abstract void onSuccess(String url, String method, String data);

    public abstract void onFailure(String url, String method, String msg);

    public abstract void onComplete(String url, String method);

}