package cn.lsmya.helper.mvp;

import android.os.Bundle;

import androidx.annotation.Nullable;

import cn.lsmya.helper.activity.BaseToolBarActivity;
import cn.lsmya.helper.util.ToastHelper;

public abstract class BaseMvpActivity<P extends BaseMvpPresenter> extends BaseToolBarActivity {

    private P mPresenter;

    /**
     * 获取布局id
     *
     * @return 布局id
     */
    public abstract int getLayout();

    public abstract void attachView();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(getLayout());
        attachView();
    }

    @Override
    protected void onDestroy() {
        if (getPresenter() != null) {
            getPresenter().detachView();
        }
        super.onDestroy();
    }

    public void setPresenter(P presenter) {
        mPresenter = presenter;
    }

    public P getPresenter() {
        return mPresenter;
    }

    public void showToast(String text) {
        ToastHelper.showText(text);
    }

    public void showToastSuccess(String text) {
        ToastHelper.showSuccess(text);
    }

    public void showToastError(String text) {
        ToastHelper.showError(text);
    }
}