package cn.lsmya.helper.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

import androidx.annotation.Nullable;

import cn.lsmya.helper.R;
import cn.lsmya.helper.util.DisplayUtil;

public class ProgressView extends View {
    /**
     * 字体大小
     */
    private float textSize;
    /**
     * 字体颜色
     */
    private int textColor;
    /**
     * 进度条宽度
     */
    private float width;
    /**
     * 进度条颜色
     */
    private int progressColor;
    /**
     * 进度条背景颜色
     */
    private int progressBackgroundColor;


    private Rect textBoundRect;

    private Paint paintText;
    private Paint paint;
    private Paint mPaint;
    private float progress;
    private float m;

    public ProgressView(Context context) {
        this(context, null);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);


        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.progressView);
        textSize = typedArray.getDimensionPixelSize(R.styleable.progressView_textSize
                , DisplayUtil.dp2px(context, 20));
        width = typedArray.getDimensionPixelSize(R.styleable.progressView_width
                , DisplayUtil.dp2px(context, 15));
        textColor = typedArray.getColor(R.styleable.progressView_textColor, Color.BLACK);
        progressColor = typedArray.getColor(R.styleable.progressView_progressColor, Color.GREEN);
        progressBackgroundColor = typedArray.getColor(R.styleable.progressView_progressBackgroundColor, Color.LTGRAY);
        typedArray.recycle();
        paintText = new Paint();
        paint = new Paint();
        mPaint = new Paint();
        paintText.setAntiAlias(true);
        paintText.setStyle(Paint.Style.FILL);
        paintText.setTextSize(textSize);
        paintText.setTextAlign(Paint.Align.CENTER);
        paintText.setColor(textColor);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(width);
        paint.setColor(progressBackgroundColor);
        mPaint.setAntiAlias(true);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeWidth(width);
        mPaint.setColor(progressColor);
        textBoundRect = new Rect();
        m = width / 2;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));

        int childWidthSize = getMeasuredWidth();
        heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, MeasureSpec.EXACTLY);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);


        RectF oval = new RectF(m, m, getWidth() - m, getHeight() - m);
        canvas.drawArc(oval, -90, 360, false, paint);
        canvas.drawArc(oval, -90, 360f * progress / 100f, false, mPaint);

        String textStr = ((int) progress) + "%";
        paintText.getTextBounds(textStr, 0, textStr.length(), textBoundRect);
        canvas.drawText(textStr, getWidth() / 2, getHeight() / 2 + textBoundRect.height() / 2, paintText);

    }

    public void setProgress(float progress) {
        this.progress = progress;
        invalidate();
    }

    public float getProgress() {
        return progress;
    }

    public static int dip2px(Context context, float dpValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }
}
