package cn.lsmya.helper.imageview;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;

/**
 * 正方形的ImageView（高度由宽度决定）
 */
public class RxWidthImageView extends AppCompatImageView {

    public RxWidthImageView(@NonNull Context context) {
        super(context);
    }

    public RxWidthImageView(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RxWidthImageView(@NonNull Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);

    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));

        int childWidthSize = getMeasuredWidth();
        //高度和宽度一样
        heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, MeasureSpec.EXACTLY);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}