package rx.library.kit.picker;

import android.content.Context;
import android.content.Intent;

import java.util.ArrayList;

public class RxImagePicker {

    private Context mContext;
    /**
     * 是否单选单选模式
     */
    private boolean SINGLE_PICK = false;
    /**
     * 可以选择的图片数目
     */
    private int DEFAULT_PICK_SIZE = 9;

    public RxImagePicker(Context context) {
        mContext = context;
    }

    public static RxImagePicker newBuilder(Context context) {
        return new RxImagePicker(context);
    }

    public RxImagePicker setMaxPickSize(int size) {
        DEFAULT_PICK_SIZE = size;
        return this;
    }

    public RxImagePicker openSinglePick() {
        return setSinglePick(true);
    }

    public RxImagePicker setSinglePick(boolean singlePick) {
        SINGLE_PICK = singlePick;
        return this;
    }

    public void build(RxPickerCallback callback) {
        AlbumActivity.setOnPickerCallback(callback);
        Intent intent = new Intent(mContext, AlbumActivity.class);
        intent.putExtra("single", SINGLE_PICK);
        intent.putExtra("maxSize", SINGLE_PICK ? 1 : DEFAULT_PICK_SIZE);
        mContext.startActivity(intent);
    }

    public static void showBigImage(Context context, String... image) {
        ArrayList<String> list = new ArrayList<>();
        for (String s : image) {
            list.add(s);
        }
        context.startActivity(new Intent(context, ImageBigActivity.class)
                .putStringArrayListExtra("list", list));


    }

    public static void showBigImage(Context context, ArrayList<String> list) {
        context.startActivity(new Intent(context, ImageBigActivity.class)
                .putStringArrayListExtra("list", list));


    }
}
