package android.library.util.http;

import android.text.TextUtils;
import okhttp3.OkHttpClient;

public class ApiInitialize {

    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int ERROR = 3;

    public static String mBaseUrl;
    /**
     * 只能初始化一次,第二次将抛出异常
     */
    private static OkHttpClient mOkHttpClient;

    public static void init(OkHttpClient okHttpClient) {
        if (mOkHttpClient != null) {
            throw new IllegalArgumentException("OkHttpClient can only be initialized once");
        }
        mOkHttpClient = okHttpClient;
    }

    static OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = HttpSender.getDefaultOkHttpClient();
        }
        return mOkHttpClient;
    }

    public static void setDebug(boolean debug) {
        setDebug(debug, DEBUG);
    }

    public static void setDebug(boolean debug, int level) {
        HttpLogUtil.setDebug(debug, level);
    }

    public static String getBaseUrl() {
        return TextUtils.isEmpty(mBaseUrl) ? "" : mBaseUrl;
    }

    public static void setBaseUrl(String baseUrl) {
        mBaseUrl = baseUrl;
    }
}
