package android.library.util

import android.content.Context
import android.widget.Toast

class ToastUtil private constructor() {
    companion object {
        private var toast: Toast? = null

        @JvmStatic
        fun showText(context: Context, msg: String) {
            if (toast == null) {
                toast = Toast.makeText(context, msg, Toast.LENGTH_SHORT)
            } else {
                toast!!.setText(msg)
            }
            toast!!.show()
        }

        @JvmStatic
        fun showText(context: Context, gravity: Int, msg: String) {
            if (toast == null) {
                toast = Toast.makeText(context, msg, Toast.LENGTH_SHORT)
            } else {
                toast!!.setText(msg)
            }
            toast!!.setGravity(gravity, 0, 0)
            toast!!.show()
        }

    }
}