package rx.library.kit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.InputFilter;
import android.text.InputType;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

import rx.library.kit.R;

import java.util.ArrayList;

/**
 *  验证码控件
 *  @author lsm
 */
public class AuthCodeView extends LinearLayout implements TextWatcher, View.OnKeyListener, View.OnFocusChangeListener {

    private ArrayList<EditText> mEditTextList;

    /**
     * 默认输入框数量
     */
    private int mDefNumber = 4;

    public AuthCodeView(Context context) {
        super(context);
        init(context, null);
    }

    public AuthCodeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public AuthCodeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        setOrientation(HORIZONTAL);
        setGravity(Gravity.CENTER);
        mEditTextList = new ArrayList<>();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.authCode);
            mDefNumber = a.getInteger(R.styleable.authCode_number, mDefNumber);
        }
        for (int i = 0; i < mDefNumber; i++) {
            EditText editText = new EditText(context);
            editText.setGravity(Gravity.CENTER);
            editText.setInputType(InputType.TYPE_CLASS_NUMBER);
            InputFilter[] filters = {new InputFilter.LengthFilter(1)};
            editText.setFilters(filters);
            editText.addTextChangedListener(this);
            editText.setOnKeyListener(this);
            editText.setOnFocusChangeListener(this);
            mEditTextList.add(editText);
            addView(editText);
            //设置第一个editText获取焦点
            if (i == 0) {
                editText.setFocusable(true);
            }
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        // 调整item的宽度
        if (mEditTextList.size() != 0) {
            int width = getResources().getDisplayMetrics().widthPixels / (mEditTextList.size());
            for (int i = 0; i < mEditTextList.size(); i++) {
                View view = mEditTextList.get(i);
                LayoutParams params = new LayoutParams(width, ViewGroup.LayoutParams.MATCH_PARENT);
                view.setLayoutParams(params);
            }
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {

    }

    @Override
    public void afterTextChanged(Editable s) {
        if (s.length() != 0) {
            focus();
        }
    }


    private void focus() {
        int count = getChildCount();
        EditText editText;
        //利用for循环找出还最前面那个还没被输入字符的EditText，并把焦点移交给它。
        for (int i = 0; i < count; i++) {
            editText = (EditText) getChildAt(i);
            if (editText.getText().length() < 1) {
                editText.setCursorVisible(true);
                editText.requestFocus();
                return;
            } else {
                editText.setCursorVisible(false);
            }
        }
    }


    @Override
    public boolean onKey(View v, int keyCode, KeyEvent event) {
        //博主手机不好，经常点一次却触发两次`onKey`事件，就设置了一个防止多点击，间隔100毫秒。
        //循环检测有字符的`editText`，把其置空，并获取焦点。
        for (int i = mDefNumber - 1; i >= 0; i--) {
            EditText editText = mEditTextList.get(i);
            if (editText.getText().length() >= 1) {
                editText.setText(null);
                editText.setCursorVisible(true);
                editText.requestFocus();
                return false;

            }
        }
        return false;
    }

    @Override
    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            focus();
        }
    }

    /**
     * 获取验证码内容
     *
     * @return
     */
    public String getCode() {
        String code = "";
        for (EditText editText : mEditTextList) {
            code = code + editText.getText().toString();
        }
        return code;
    }
}