package rx.library.kit.activity

import android.graphics.PorterDuff
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.view.Menu
import android.view.MenuItem
import androidx.annotation.DrawableRes
import rx.library.kit.RxKit
import rx.library.kit.RxKit.Companion.getContext

open class BaseToolBarActivity : BaseActivity() {

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, onClickListener: MenuItem.OnMenuItemClickListener) {
        val menuItem = getToolbar().menu.add(addColor(text, RxKit.getTitleTextColor()))
        menuItem.setOnMenuItemClickListener(onClickListener)
        menuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS)
    }

    /**
     * 修改菜单按钮的文字内容
     */
    fun changeMenuItemTextView(text: String, item: MenuItem) {
        changeMenuItemTextView(text, item, RxKit.getTitleTextColor())
    }

    fun changeMenuItemTextView(text: String, item: MenuItem, color: Int) {
        item.title = addColor(text, color)
    }

    override fun onPrepareOptionsMenu(menu: Menu?): Boolean {
        return super.onPrepareOptionsMenu(menu)
    }

    /**
     * 添加一个图标菜单按钮
     */
    fun addMenuItemImageView(@DrawableRes resId: Int, onClickListener: MenuItem.OnMenuItemClickListener) {
        val menuItem = getToolbar().menu.add("")
        menuItem.setIcon(resId)
        menuItem.setOnMenuItemClickListener(onClickListener)
        menuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS)
        menuItem.icon.setColorFilter(RxKit.getTitleTextColor(), PorterDuff.Mode.SRC_ATOP)
    }


    private fun addColor(text: CharSequence, color: Int): SpannableStringBuilder {
        val builder = SpannableStringBuilder(text)
        if (color != 0) {
            builder.setSpan(
                ForegroundColorSpan(color), 0, text.length,
                Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
            )
        }
        return builder
    }


    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        val itemId = item!!.itemId
        if (itemId == android.R.id.home) {

            setNavigationIconClick()
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onMenuOpened(featureId: Int, menu: Menu?): Boolean {
        if (menu != null) {
            if (menu.javaClass.simpleName == "MenuBuilder") {
                try {
                    val method = menu.javaClass
                        .getDeclaredMethod("setOptionalIconsVisible", java.lang.Boolean.TYPE)
                    method.isAccessible = true
                    method.invoke(menu, true)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
        return super.onMenuOpened(featureId, menu)
    }

    private fun getStatusHeight(): Int {
        var statusHeight = -1
        try {
            val clazz = Class.forName("com.android.internal.R\$dimen")
            val `object` = clazz.newInstance()
            val id = clazz.getField("status_bar_height")[`object`] as Int
            statusHeight = getContext().resources.getDimensionPixelSize(id)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
        return statusHeight
    }

}