package rx.library.kit.activity

import android.app.Activity
import android.view.Menu
import android.view.MenuItem
import android.view.inputmethod.InputMethodManager
import androidx.annotation.MenuRes

open class BaseToolBarMenuActivity : BaseToolBarActivity() {

    /**
     * @return menu
     */
    @MenuRes
    protected open fun menu(): Int {
        return 0
    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        if (menu() != 0) {
            menuInflater.inflate(menu(), menu)
        }
        onMenuCreate(menu)
        return super.onCreateOptionsMenu(menu)
    }

    protected open fun onMenuCreate(menu: Menu?) {}

    protected open fun hideInputMethod() {
        val imm = this.getSystemService(
            Activity.INPUT_METHOD_SERVICE
        ) as InputMethodManager
        val view = currentFocus
        if (view != null) {
            imm.hideSoftInputFromWindow(view.windowToken, 0)
        }
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        val itemId = item!!.itemId
        if (itemId == android.R.id.home) {
            hideInputMethod()
            setNavigationIconClick()
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onMenuOpened(featureId: Int, menu: Menu?): Boolean {
        if (menu != null) {
            if (menu.javaClass.simpleName == "MenuBuilder") {
                try {
                    val method = menu.javaClass
                        .getDeclaredMethod("setOptionalIconsVisible", java.lang.Boolean.TYPE)
                    method.isAccessible = true
                    method.invoke(menu, true)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
        return super.onMenuOpened(featureId, menu)
    }
}