package rx.library.kit;


import android.annotation.TargetApi;
import android.app.Activity;

import androidx.annotation.ColorInt;

import com.gyf.immersionbar.ImmersionBar;

public class StatusBarUtil {
    /**
     * 修改状态栏为全透明
     *
     * @param activity
     */
    @TargetApi(19)
    public static void transparencyBar(Activity activity) {
        ImmersionBar.with(activity)
                .transparentStatusBar().init();  //透明状态栏，不写默认透明色
    }

    /**
     * 状态栏亮色模式，设置状态栏黑色文字、图标，
     *
     * @param activity
     * @return 当前设备是否支持状态栏字体变色
     */
    public static boolean setStatusBarLightMode(Activity activity, @ColorInt int statusBarColor) {
        if (ImmersionBar.isSupportStatusBarDarkFont()) {
            ImmersionBar.with(activity)
                    .statusBarDarkFont(true)
                    .supportActionBar(true)
                    .fitsSystemWindows(true)
                    .statusBarColorInt(statusBarColor)
                    .init();

            return true;
        }
        return false;
    }

    /**
     * 设置状态栏白色字体图标
     * 支持 4.4 以上版本 MIUI 和 Flyme，以及 6.0 以上版本的其他 Android
     */
    public static void setStatusBarDarkMode(Activity activity, @ColorInt int statusBarColor) {
        ImmersionBar.with(activity)
                .statusBarDarkFont(false)
                .fitsSystemWindows(true)
                .supportActionBar(true)
                .statusBarColorInt(statusBarColor)
                .init();
    }
}
