package rx.library.kit;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.tencent.smtt.sdk.TbsReaderView;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.File;

import rx.library.kit.activity.BaseToolBarActivity;

public class OpenFileUtil extends BaseToolBarActivity {
    private TbsReaderView mTbsReaderView;
    private RelativeLayout layout;
    private String filePath;

    public static void open(Activity activity, String filePath) {
        open(activity, "查看文件", filePath, false);
    }

    public static void open(Activity activity, String filePath, boolean statusBarLightMode) {
        open(activity, "查看文件", filePath, statusBarLightMode);
    }

    public static void open(Activity activity, String title, String filePath) {
        open(activity, title, filePath, false);
    }

    public static void open(Activity activity, String title, String filePath, boolean statusBarLightMode) {
        Intent intent = new Intent(activity, OpenFileUtil.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        intent.putExtra("statusBarLightMode", statusBarLightMode);
        activity.startActivity(intent);
    }

    public static void open(Activity activity, String filePath, int requestCode) {
        open(activity, "查看文件", filePath, requestCode, false);
    }

    public static void open(Activity activity, String filePath, int requestCode, boolean statusBarLightMode) {
        open(activity, "查看文件", filePath, requestCode, statusBarLightMode);
    }

    public static void open(Activity activity, String title, String filePath, int requestCode) {
        open(activity, title, filePath, requestCode, false);
    }

    public static void open(Activity activity, String title, String filePath, int requestCode, boolean statusBarLightMode) {
        Intent intent = new Intent(activity, OpenFileUtil.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        intent.putExtra("statusBarLightMode", statusBarLightMode);
        activity.startActivityForResult(intent, requestCode);
    }

    @NotNull
    @Override
    public String getTitleText() {
        return getIntent().getStringExtra("title");
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.kit_activity_open_file);
        if (getIntent().getBooleanExtra("statusBarLightMode", false)) {
            setStatusBarLightMode();
        }
        filePath = getIntent().getStringExtra("filePath");
        layout = findViewById(R.id.kit_openFileLayout);
        mTbsReaderView = new TbsReaderView(this, null);
        layout.addView(mTbsReaderView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        bundle.putString("tempPath", new File(filePath).getParent());
        boolean result = mTbsReaderView.preOpen(parseFormat(new File(filePath).getName()), false);
        if (result) {
            mTbsReaderView.openFile(bundle);
        }
    }

    private String parseFormat(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            mTbsReaderView.onStop();
        } catch (Exception e) {
        }
    }
}
