package android.library.util.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;

import android.library.util.R;

/**
 * 底部弹出dialog，宽度为屏幕宽度十分之九
 * 实例化时传入布局id
 */
public class BottomDialogById extends Dialog {

    private Context context;
    private int layoutId;

    public BottomDialogById(@NonNull Context context, int layoutId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.layoutId = layoutId;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(Gravity.BOTTOM);
        window.setWindowAnimations(R.style.bottom_menu_animation);
        setContentView(layoutId);
        WindowManager manager = ((Activity) context).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels * 9 / 10;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);
    }

}
