package rx.library.kit.http.other;

import rx.library.kit.http.ApiDownloadCallBack;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;

import java.io.IOException;

public class DownloadResponseBody extends ResponseBody {

    private Response originalResponse;
    private ApiDownloadCallBack apiDownloadCallBack;

    public DownloadResponseBody(Response originalResponse, ApiDownloadCallBack apiDownloadCallBack) {
        this.originalResponse = originalResponse;
        this.apiDownloadCallBack = apiDownloadCallBack;
    }

    @Override
    public MediaType contentType() {
        return originalResponse.body().contentType();
    }

    @Override
    public long contentLength() {
        return originalResponse.body().contentLength();
    }

    @Override
    public BufferedSource source() {
        return Okio.buffer(new ForwardingSource(originalResponse.body().source()) {
            private long bytesReaded = 0;

            private int oldProgress = -1;

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                bytesReaded += bytesRead == -1 ? 0 : bytesRead;
                if (apiDownloadCallBack != null) {

                    int progress = (int) ((bytesReaded) * 100 / originalResponse.body().contentLength());
                    if (oldProgress != progress) {
                        oldProgress = progress;
                        apiDownloadCallBack.progress(originalResponse.request().url().toString(), oldProgress);
                    }
                }
                return bytesRead;
            }
        });
    }

}