package rx.library.kit.http.other;

import rx.library.kit.http.ApiDownloadCallBack;
import rx.library.kit.http.ApiInitialize;
import androidx.annotation.NonNull;
import okhttp3.*;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class QXHttpSender {


    /**
     * 连接、读写超时均为10s、添加信任证书并忽略host验证
     *
     * @return 返回默认的OkHttpClient对象
     */
    public static OkHttpClient getDefaultOkHttpClient() {
        return new OkHttpClient.Builder()
                .connectTimeout(10, TimeUnit.SECONDS)
                .readTimeout(10, TimeUnit.SECONDS)
                .writeTimeout(10, TimeUnit.SECONDS)
                .build();
    }


    /**
     * 同步执行请求
     *
     * @param request 请求参数
     * @return Http响应结果
     * @throws IOException 超时、网络异常
     */
    public static void execute(@NonNull Request request, final Callback callBack) {
        newCall(request).enqueue(callBack);
    }

    /**
     * 同步执行下载文件的请求
     *
     * @param request 请求参数
     * @return Http响应结果
     * @throws IOException 超时、网络异常
     */
    public static void executeDownload(@NonNull Request request, final Callback callBack, final ApiDownloadCallBack apiDownloadCallBack) {
        // 重写ResponseBody监听请求
        Interceptor interceptor = new Interceptor() {
            @Override
            public Response intercept(Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder()
                        .body(new DownloadResponseBody(originalResponse, apiDownloadCallBack))
                        .build();
            }
        };
        OkHttpClient downloadOkHttpClient = ApiInitialize.getDownloadOkHttpClient();
        if (downloadOkHttpClient == null) {
            downloadOkHttpClient = new OkHttpClient.Builder()
                    .addNetworkInterceptor(interceptor).build();
        }
        ApiInitialize.setDownloadOkHttpClient(downloadOkHttpClient);
        newCall(downloadOkHttpClient, request).enqueue(callBack);
    }

    static Call newCall(Request request) {
        return newCall(ApiInitialize.getOkHttpClient(), request);
    }

    static Call newCall(OkHttpClient client, Request request) {
        return client.newCall(request);
    }


}







