package rx.library.kit.util

import android.annotation.SuppressLint
import android.content.Context
import android.content.SharedPreferences

class RxSharedPreferences {

    companion object {

        @SuppressLint("StaticFieldLeak")
        private lateinit var mContext: Context

        private var mEncode = false

        @JvmStatic
        val instance: RxSharedPreferences by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            RxSharedPreferences()
        }

        @JvmStatic
        fun init(context: Context) {
            mContext = context
        }

        @JvmStatic
        fun openEncode(encode: Boolean) {
            mEncode = encode
        }
    }

    /**
     * 保存String
     *
     * @param key
     * @param value
     */
    fun putString(key: String, value: String) {
        getSharedPreferences().edit()
            .putString(getEncodeWord(key), getEncodeWord(value)).apply()
    }

    fun putString(name: String, key: String, value: String) {
        getSharedPreferences(getEncodeWord(name)).edit()
            .putString(getEncodeWord(key), getEncodeWord(value)).apply()
    }

    fun putStringCommit(key: String, value: String) {
        getSharedPreferences().edit().putString(getEncodeWord(key), getEncodeWord(value)).commit()
    }

    fun putStringCommit(name: String, key: String, value: String) {
        getSharedPreferences(getEncodeWord(name)).edit()
            .putString(getEncodeWord(key), getEncodeWord(value)).commit()
    }

    fun getString(key: String, defaultValue: String): String? {
        val defaultString = getSharedPreferences().getString(getEncodeWord(key), defaultValue)
        return if (defaultString == defaultValue) {
            defaultString
        } else {
            getDecodeWord(defaultString)
        }
    }

    fun getString(name: String, key: String, defaultValue: String): String? {
        val defaultString =
            getSharedPreferences(getEncodeWord(name)).getString(getEncodeWord(key), defaultValue)
        return if (defaultString == defaultValue) {
            defaultString
        } else {
            getDecodeWord(defaultString)
        }
    }

    /**
     * 保存Int
     *
     * @param key
     * @param value
     */
    fun putInt(key: String, value: Int) {
        getSharedPreferences().edit().putInt(getEncodeWord(key), value).apply()
    }

    fun putInt(name: String, key: String, value: Int) {
        getSharedPreferences(getEncodeWord(name)).edit().putInt(getEncodeWord(key), value).apply()
    }

    fun putIntCommit(key: String, value: Int) {
        getSharedPreferences().edit().putInt(getEncodeWord(key), value).commit()
    }

    fun putIntCommit(name: String, key: String, value: Int) {
        getSharedPreferences(getEncodeWord(name)).edit().putInt(getEncodeWord(key), value).commit()
    }

    fun getInt(key: String, defaultValue: Int): Int {
        return getSharedPreferences().getInt(getEncodeWord(key), defaultValue)
    }

    fun getInt(name: String, key: String, defaultValue: Int): Int {
        return getSharedPreferences(getEncodeWord(name)).getInt(getEncodeWord(key), defaultValue)
    }

    /**
     * 保存Long
     *
     * @param key
     * @param value
     */
    fun putLong(key: String, value: Long?) {
        getSharedPreferences().edit().putLong(getEncodeWord(key), value!!).apply()
    }

    fun putLong(name: String, key: String, value: Long?) {
        getSharedPreferences(getEncodeWord(name)).edit().putLong(getEncodeWord(key), value!!)
            .apply()
    }

    fun putLongCommit(key: String, value: Long?) {
        getSharedPreferences().edit().putLong(getEncodeWord(key), value!!).commit()
    }

    fun putLongCommit(name: String, key: String, value: Long?) {
        getSharedPreferences(getEncodeWord(name)).edit().putLong(getEncodeWord(key), value!!)
            .commit()
    }

    fun getLong(key: String, defaultValue: Long?): Long? {
        return getSharedPreferences().getLong(getEncodeWord(key), defaultValue!!)
    }

    fun getLong(name: String, key: String, defaultValue: Long?): Long? {
        return getSharedPreferences(getEncodeWord(name)).getLong(getEncodeWord(key), defaultValue!!)
    }

    /**
     * 保存Boolean
     *
     * @param key
     * @param value
     */
    fun putBoolean(key: String, value: Boolean) {
        getSharedPreferences().edit().putBoolean(getEncodeWord(key), value).apply()
    }

    fun putBoolean(name: String, key: String, value: Boolean) {
        getSharedPreferences(getEncodeWord(name)).edit().putBoolean(getEncodeWord(key), value)
            .apply()
    }

    fun putBooleanCommit(key: String, value: Boolean) {
        getSharedPreferences().edit().putBoolean(getEncodeWord(key), value).commit()
    }

    fun putBooleanCommit(name: String, key: String, value: Boolean) {
        getSharedPreferences(getEncodeWord(name)).edit().putBoolean(getEncodeWord(key), value)
            .commit()
    }

    fun getBoolean(key: String, defaultValue: Boolean): Boolean? {
        return getSharedPreferences().getBoolean(getEncodeWord(key), defaultValue)
    }

    fun getBoolean(name: String, key: String, defaultValue: Boolean): Boolean? {
        return getSharedPreferences(getEncodeWord(name)).getBoolean(
            getEncodeWord(key),
            defaultValue
        )
    }

    /**
     * 保存Float
     *
     * @param key
     * @param value
     */
    fun putFloat(key: String, value: Float) {
        getSharedPreferences().edit().putFloat(getEncodeWord(key), value).apply()
    }

    fun putFloat(name: String, key: String, value: Float) {
        getSharedPreferences(getEncodeWord(name)).edit().putFloat(getEncodeWord(key), value).apply()
    }

    fun putFloatCommit(key: String, value: Float) {
        getSharedPreferences().edit().putFloat(getEncodeWord(key), value).commit()
    }

    fun putFloatCommit(name: String, key: String, value: Float) {
        getSharedPreferences(getEncodeWord(name)).edit().putFloat(getEncodeWord(key), value)
            .commit()
    }

    fun getFolat(key: String, defaultValue: Float): Float? {
        return getSharedPreferences().getFloat(getEncodeWord(key), defaultValue)
    }

    fun getFolat(name: String, key: String, defaultValue: Float): Float? {
        return getSharedPreferences(getEncodeWord(name)).getFloat(getEncodeWord(key), defaultValue)
    }

    /**
     * 清除数据
     */
    fun remove(key: String) {
        getSharedPreferences().edit().remove(getEncodeWord(key)).apply()
    }

    fun remove(name: String, key: String) {
        getSharedPreferences(getEncodeWord(name)).edit().remove(getEncodeWord(key)).apply()
    }

    fun removeAll() {
        getSharedPreferences().edit().clear().apply()
    }

    fun removeAll(name: String) {
        getSharedPreferences(getEncodeWord(name)).edit().clear().apply()
    }

    fun removeCommit(key: String) {
        getSharedPreferences().edit().remove(getEncodeWord(key)).commit()
    }

    fun removeCommit(name: String, key: String) {
        getSharedPreferences(getEncodeWord(name)).edit().remove(getEncodeWord(key)).commit()
    }

    fun removeAllCommit() {
        getSharedPreferences().edit().clear().commit()
    }

    fun removeAllCommit(name: String) {
        getSharedPreferences(getEncodeWord(name)).edit().clear().commit()
    }

    private fun getSharedPreferences(): SharedPreferences {
        return getSharedPreferences(getEncodeWord("default_sp_Name"))
    }

    private fun getSharedPreferences(name: String): SharedPreferences {
        return mContext.getSharedPreferences(name, Context.MODE_PRIVATE)
    }

    private fun getEncodeWord(value: String): String = if (mEncode) {
        Base64Util.encodeWord(value)
    } else {
        value
    }

    private fun getDecodeWord(value: String): String = if (mEncode) {
        Base64Util.decodeWord(value)
    } else {
        value
    }

}