package rx.library.kit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import rx.library.kit.R;
import rx.library.kit.badgeview.DisplayUtil;

public class ItemView extends LinearLayout {
    private ImageView leftImageView;
    private ImageView rightImageView;
    private ImageView descImageView;
    private TextView titleTextView;
    private TextView descTextView;
    private TextView badgeTextView;
    private View dividerView;

    public ItemView(Context context) {
        super(context);
        init(context, null);
    }

    public ItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public ItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        View view = inflate(context, R.layout.kit_option_item, this);
        leftImageView = view.findViewById(R.id.kit_opinionItem_leftImageView);
        rightImageView = view.findViewById(R.id.kit_opinionItem_rightImageView);
        descImageView = view.findViewById(R.id.kit_opinionItem_descImageView);
        titleTextView = view.findViewById(R.id.kit_opinionItem_titleTextView);
        descTextView = view.findViewById(R.id.kit_opinionItem_descTextView);
        badgeTextView = view.findViewById(R.id.kit_opinionItem_badgeTextView);
        dividerView = view.findViewById(R.id.kit_opinionItem_dividerLine);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ItemView);
        boolean dividerAlignToTitle = false;
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.ItemView_leftSrc) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    leftImageView.setVisibility(VISIBLE);
                    leftImageView.setImageResource(resId);
                } else {
                    leftImageView.setVisibility(GONE);
                }
            } else if (attr == R.styleable.ItemView_leftIconSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, DisplayUtil.dp2px(context, 40));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) leftImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                leftImageView.setLayoutParams(layoutParams);

            } else if (attr == R.styleable.ItemView_title) {
                titleTextView.setText(typedArray.getString(attr));
            } else if (attr == R.styleable.ItemView_titleSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, DisplayUtil.dp2px(context, 18));
                titleTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.ItemView_titleColor) {
                int color = typedArray.getColor(attr, Color.BLACK);
                titleTextView.setTextColor(color);
            } else if (attr == R.styleable.ItemView_badge_count) {
                int count = typedArray.getInt(attr, 0);
                if (count > 0) {
                    badgeTextView.setVisibility(VISIBLE);
                    count = count > 99 ? 99 : count;
                    badgeTextView.setText(String.valueOf(count));
                }
            } else if (attr == R.styleable.ItemView_desc) {
                String desc = typedArray.getString(attr);
                if (!TextUtils.isEmpty(desc)) {
                    descTextView.setVisibility(VISIBLE);
                    descTextView.setText(desc);
                }
            } else if (attr == R.styleable.ItemView_descSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, DisplayUtil.dp2px(context, 18));
                descTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.ItemView_descColor) {
                int color = typedArray.getColor(attr, Color.BLACK);
                descTextView.setTextColor(color);
            } else if (attr == R.styleable.ItemView_rightSrc) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    rightImageView.setImageResource(resId);
                    rightImageView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.ItemView_rightIconSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, DisplayUtil.dp2px(context, 40));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) rightImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                rightImageView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.ItemView_descSrc) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    descImageView.setImageResource(resId);
                    descImageView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.ItemView_descIconSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, DisplayUtil.dp2px(context, 40));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) descImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                descImageView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.ItemView_showLine) {
                boolean aBoolean = typedArray.getBoolean(attr, false);
                if (aBoolean) {
                    dividerView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.ItemView_dividerAlignToTitle) {
                dividerAlignToTitle = typedArray.getBoolean(attr, false);
            }

        }
        if (dividerAlignToTitle) {
            LayoutParams layoutParams = (LayoutParams) dividerView.getLayoutParams();
            int dimension = typedArray.getDimensionPixelSize(R.styleable.ItemView_leftIconSize, DisplayUtil.dp2px(context, 40));
            int margin = leftImageView.getVisibility() == VISIBLE ? (32 + DisplayUtil.px2dp(context, dimension)) : 16;
            layoutParams.leftMargin = dp2px(margin);
            dividerView.setLayoutParams(layoutParams);
            dividerView.invalidate();
        }
        typedArray.recycle();
    }

    public ImageView getLeftImageView() {
        return leftImageView;
    }

    public ImageView getRightImageView() {
        return rightImageView;
    }

    public void setTitle(String title) {
        if (titleTextView != null) {
            titleTextView.setText(title);
        }
    }


    public void setDesc(String desc) {
        if (descTextView != null) {
            if (TextUtils.isEmpty(desc)) {
                descTextView.setVisibility(GONE);
            } else {
                descTextView.setVisibility(VISIBLE);
                descTextView.setText(desc);
            }
        }
    }

    public void setDividerVisibility(int visibility) {
        if (dividerView != null) {
            dividerView.setVisibility(visibility);
        }
    }

    private int dp2px(int dip) {
        float density = getContext().getResources().getDisplayMetrics().density;
        return (int) (dip * density + 0.5f);
    }
}