package android.library.util.recyclerview;

import android.view.View;

/**
 * recyclerView中item的点击事件
 */
public class OnItemViewClickListener implements View.OnClickListener {
    private int position;
    private BaseViewAdapter.OnItemClickListener onItemClickListener;

    public OnItemViewClickListener(BaseViewAdapter.OnItemClickListener onItemClickListener, int position) {
        this.onItemClickListener = onItemClickListener;
        this.position = position;
    }

    @Override
    public void onClick(View v) {
        if (onItemClickListener != null) {
            this.onItemClickListener.onItemClick(position);
        }
    }
}