package android.library.util.http;

import android.util.Log;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class Api {


    /**
     * Get 请求
     */
    public static GetBuilderHttp get() {
        return GetBuilderHttp.with(null);
    }

    public static GetBuilderHttp get(String url) {
        return GetBuilderHttp.with(url);
    }


    /**
     * Post From请求
     */
    public static PostFromBuilderHttp postFrom() {
        return PostFromBuilderHttp.with(null);
    }

    public static PostFromBuilderHttp postFrom(String url) {
        return PostFromBuilderHttp.with(url);
    }

    /**
     * Post JSON请求
     */
    public static PostJSONBuilderHttp postJSON() {
        return PostJSONBuilderHttp.with(null);
    }

    public static PostJSONBuilderHttp postJSON(String url) {
        return PostJSONBuilderHttp.with(url);
    }

    public static void cancel(final Object tag) {
        OkHttpClient mOkHttpClient = ApiInitialize.getOkHttpClient();
        try {
            for (Call call : mOkHttpClient.dispatcher().queuedCalls()) {
                if (call.request().tag().toString().contains(tag.toString())) {
                    call.cancel();
                }
            }
            for (Call call : mOkHttpClient.dispatcher().runningCalls()) {
                if (call.request().tag().toString().contains(tag.toString())) {
                    call.cancel();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
