package rx.library.kit.activity

import android.app.Dialog
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.view.*
import android.view.LayoutInflater
import androidx.annotation.DrawableRes
import androidx.appcompat.app.ActionBar
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import rx.library.kit.RxKit
import rx.library.kit.StatusBar
import rx.library.kit.StatusBarUtil
import rx.library.kit.loading.LoadingView
import rx.library.kit.util.DensityUtils
import rx.library.kit.util.RxDeviceInfo

open class BaseToolBarActivity : AppCompatActivity() {

    private lateinit var toolbar: Toolbar
    private var loadingView: View? = null
    private var emptyView: View? = null
    private var loadingDialog: Dialog? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setCustomActionBar()
    }

    private fun setCustomActionBar() {
        val lp = ActionBar.LayoutParams(
            ActionBar.LayoutParams.MATCH_PARENT,
            ActionBar.LayoutParams.MATCH_PARENT,
            Gravity.CENTER
        )
        val mActionBarView =
            LayoutInflater.from(this).inflate(rx.library.kit.R.layout.kit_toolbar, null)
        toolbar = mActionBarView.findViewById(rx.library.kit.R.id.kit_toolbar)

        toolbar.title = getTitleText()
        toolbar.setTitleTextColor(getTitleTextColor())
        toolbar.navigationIcon = RxKit.getTitleBackIcon()
        toolbar.contentInsetStartWithNavigation = 0
        toolbar.setNavigationOnClickListener { backHomeClick() }
        toolbar.setBackgroundColor(RxKit.getTitleBackground())
        val actionBar = supportActionBar
        actionBar!!.setBackgroundDrawable(ColorDrawable(RxKit.getTitleBackground()))
        actionBar.setCustomView(mActionBarView, lp)
        actionBar.displayOptions = ActionBar.DISPLAY_SHOW_CUSTOM

        StatusBar.setColor(this, RxKit.getTitleBackground(), 0)

        setStatusBarMode(RxKit.getStatusBarMode())
    }

    fun getToolbar() = toolbar

    fun setToolbarBackgroundColor(color: Int) {
        getToolbar().setBackgroundColor(color)
        supportActionBar!!.setBackgroundDrawable(ColorDrawable(color))
    }

    fun setToolbarTitleTextColor(color: Int) {
        getToolbar().setTitleTextColor(color)
    }

    /**
     * 返回上一层
     */
    open fun backHomeClick() {
        finish()
    }

    /**
     * 获取标题内容，可重新自定义设置标题文本内容
     */
    open fun getTitleText(): String {
        return title.toString()
    }

    /**
     * 获取标题颜色，可重新自定义设置标题文本颜色
     */
    open fun getTitleTextColor(): Int {
        return RxKit.getTitleTextColor()
    }

    fun setBackIcon(iconId: Int) {
        toolbar.setNavigationIcon(iconId)
    }

    fun showLoadingDialog(show: Boolean) {
        if (loadingDialog == null) {
            loadingDialog = Dialog(this)
        }
        loadingDialog!!.window.setBackgroundDrawableResource(android.R.color.transparent)
        loadingDialog!!.window.setDimAmount(0f)
        loadingDialog!!.setCanceledOnTouchOutside(false)
        val loadingView = LoadingView(this)
        loadingView.setColor(RxKit.getLoadingDialogColor())
        loadingView.setSize(DensityUtils.dp2px(RxKit.getLoadingDialogSize()))
        loadingDialog!!.setContentView(loadingView)
        if (show) {
            if (!loadingDialog!!.isShowing) {
                loadingDialog!!.show()
            }
        } else {
            if (loadingDialog!!.isShowing) {
                loadingDialog!!.dismiss()
            }
        }
    }

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, onClickListener: MenuItem.OnMenuItemClickListener) {
        addMenuItemTextView(text, getTitleTextColor(), onClickListener)
    }

    override fun onPrepareOptionsMenu(menu: Menu?): Boolean {
        return super.onPrepareOptionsMenu(menu)
    }

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(
        text: String,
        color: Int,
        onClickListener: MenuItem.OnMenuItemClickListener
    ) {
        val menuItem = toolbar.menu.add(addColor(text, color))
        menuItem.setOnMenuItemClickListener(onClickListener)
        menuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS)
    }

    /**
     * 添加一个图标菜单按钮
     */
    fun addMenuItemImageView(@DrawableRes resId: Int, onClickListener: MenuItem.OnMenuItemClickListener) {
        val menuItem = toolbar.menu.add("")
        menuItem.setIcon(resId)
        menuItem.setOnMenuItemClickListener(onClickListener)
        menuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS)
    }

    fun getMenuItem(position: Int): MenuItem {
        return toolbar.menu.getItem(position)
    }

    fun getMenuCount() = toolbar.menu.size()

    private fun addColor(text: CharSequence, color: Int): SpannableStringBuilder {
        val builder = SpannableStringBuilder(text)
        if (color != 0) {
            builder.setSpan(
                ForegroundColorSpan(color), 0, text.length,
                Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
            )
        }
        return builder
    }

    /**
     * 设置状态栏白底黑字
     */
    fun setStatusBarLightMode() {
        StatusBarUtil.setStatusBarLightMode(this)
        val rootView = window.decorView.findViewById<View>(android.R.id.content)
        rootView.setPadding(0, RxDeviceInfo.getStatusHeight(), 0, 0)
    }

    /**
     * 设置状态栏白底黑字
     */
    fun setStatusBarDarkMode() {
        StatusBarUtil.setStatusBarDarkMode(this)
    }

    fun setStatusBarMode(lightMode: Boolean) {
        if (lightMode) {
            setStatusBarLightMode()
        } else {
            setStatusBarDarkMode()
        }
    }

    /**
     * 显示加载布局
     */
    fun showLoading(show: Boolean) {
        if (show) {
            if (loadingView == null) {
                loadingView = LayoutInflater.from(this).inflate(RxKit.getLoadingLayout(), null)
                getRootViewGroup().addView(loadingView)
            }
        } else {
            getRootViewGroup().removeView(loadingView)
            loadingView = null
        }
    }

    /**
     * 显示空布局
     */
    fun showEmpty(show: Boolean) {
        if (show) {
            if (emptyView == null) {
                emptyView = LayoutInflater.from(this).inflate(RxKit.getEmptyLayout(), null)
                getRootViewGroup().addView(emptyView)
            }
        } else {
            getRootViewGroup().removeView(emptyView)
            emptyView = null
        }
    }

    private fun getRootViewGroup(): ViewGroup {
        return getRootView() as ViewGroup
    }

    private fun getRootView(): View {
        return window.decorView.findViewById(android.R.id.content)
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        val itemId = item!!.itemId
        if (itemId == android.R.id.home) {
            backHomeClick()
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onMenuOpened(featureId: Int, menu: Menu?): Boolean {
        if (menu != null) {
            if (menu.javaClass.simpleName == "MenuBuilder") {
                try {
                    val method = menu.javaClass
                        .getDeclaredMethod("setOptionalIconsVisible", java.lang.Boolean.TYPE)
                    method.isAccessible = true
                    method.invoke(menu, true)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
        return super.onMenuOpened(featureId, menu)
    }
}