package rx.library.kit

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.Drawable
import androidx.annotation.ColorInt
import androidx.core.content.ContextCompat
import com.tencent.smtt.sdk.QbSdk
import rx.library.kit.util.RxLog
import rx.library.kit.util.RxSharedPreferences

class RxKit {
    companion object {

        @SuppressLint("StaticFieldLeak")
        private lateinit var mContext: Context
        private var titleBackgroundColor: Int = Color.BLACK
        private var titleTextColor: Int = 0
        private var backDrawable: Drawable? = null
        private var emptyResId: Int = R.layout.kit_empty
        private var loadingResId: Int = R.layout.kit_loading
        private var loadingDialogSize: Float = 45f
        private var loadingDialogColor: Int = Color.GRAY
        private var mLightMode: Boolean = false

        @JvmStatic
        fun init(context: Context) {
            mContext = context
            RxSharedPreferences.init(mContext)
            QbSdk.setDownloadWithoutWifi(true)
            QbSdk.initX5Environment(mContext, object : QbSdk.PreInitCallback {
                override fun onCoreInitFinished() {

                }

                override fun onViewInitFinished(b: Boolean) {
                    RxLog.e("TBS", b.toString() + "")
                }
            })
        }

        @JvmStatic
        fun debug(open: Boolean) {
            RxLog.init(open)
        }

        @JvmStatic
        fun getContext(): Context = mContext

        /**
         * 初始化标题栏文本字体颜色
         */
        @JvmStatic
        fun initTitleTextColor(@ColorInt color: Int) {
            titleTextColor = color
        }

        /**
         * 获取标题栏文本字体颜色
         */
        @JvmStatic
        fun getTitleTextColor(): Int {
            return if (titleTextColor == 0) {
                ContextCompat.getColor(mContext, R.color.kit_white)
            } else {
                titleTextColor
            }
        }

        /**
         * 初始化标题栏返回按钮图标
         */
        @JvmStatic
        fun initTitleBackIcon(drawable: Drawable) {
            backDrawable = drawable
        }

        /**
         * 获取标题栏返回按钮图标
         */
        @JvmStatic
        fun getTitleBackIcon(): Drawable {
            return if (backDrawable == null) {
                ContextCompat.getDrawable(mContext, R.drawable.kit_arrow_back_black_24dp)!!
            } else {
                backDrawable!!
            }
        }

        /**
         * 设置状态栏标题栏背景颜色
         */
        @JvmStatic
        fun initTitleBackground(@ColorInt color: Int) {
            titleBackgroundColor = color
        }

        /**
         * 获取状态栏标题栏背景颜色
         */
        @JvmStatic
        fun getTitleBackground(): Int = titleBackgroundColor

        /**
         * 设置状态栏字体颜色模式
         */
        @JvmStatic
        fun initStatusBarMode(lightMode: Boolean) {
            mLightMode = lightMode
        }
        /**
         * 获取状态栏字体颜色模式
         */
        @JvmStatic
        fun getStatusBarMode(): Boolean = mLightMode

        /**
         * 设置加载弹窗大小
         */
        @JvmStatic
        fun setLoadingDialogSize(size: Float) {
            loadingDialogSize = size
        }

        /**
         * 获取加载弹窗大小
         */
        @JvmStatic
        fun getLoadingDialogSize(): Float = loadingDialogSize

        /**
         * 设置加载弹窗颜色
         */
        @JvmStatic
        fun setLoadingDialogColor(@ColorInt color: Int) {
            loadingDialogColor = color
        }

        /**
         * 获取加载弹窗颜色
         */
        @JvmStatic
        fun getLoadingDialogColor(): Int = loadingDialogColor

        /**
         * 设置页面加载布局
         */
        @JvmStatic
        fun setLoadingLayout(resId: Int) {
            loadingResId = resId
        }

        /**
         * 获取页面加载布局
         */
        @JvmStatic
        fun getLoadingLayout(): Int = loadingResId

        /**
         * 设置页面空布局
         */
        @JvmStatic
        fun setEmptyLayout(resId: Int) {
            emptyResId = resId
        }

        /**
         * 获取页面空布局
         */
        @JvmStatic
        fun getEmptyLayout(): Int = emptyResId
    }
}