package rx.library.kit.util

import android.content.Context
import android.content.SharedPreferences

class RxSharedPreferences {

    companion object {

        private lateinit var mContext: Context

        @JvmStatic
        val instance: RxSharedPreferences by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            RxSharedPreferences()
        }

        @JvmStatic
        fun init(context: Context) {
            mContext = context
        }
    }

    /**
     * 保存String
     *
     * @param key
     * @param value
     */
    fun putString(key: String, value: String) {
        getSharedPreferences().edit().putString(key, value).apply()
    }

    fun putString(name: String, key: String, value: String) {
        getSharedPreferences(name).edit().putString(key, value).apply()
    }

    fun putStringCommit(key: String, value: String) {
        getSharedPreferences().edit().putString(key, value).commit()
    }

    fun putStringCommit(name: String, key: String, value: String) {
        getSharedPreferences(name).edit().putString(key, value).commit()
    }

    fun getString(key: String, defaultValue: String): String? {
        return getSharedPreferences().getString(key, defaultValue)
    }

    fun getString(name: String, key: String, defaultValue: String): String? {
        return getSharedPreferences(name).getString(key, defaultValue)
    }

    /**
     * 保存Int
     *
     * @param key
     * @param value
     */
    fun putInt(key: String, value: Int) {
        getSharedPreferences().edit().putInt(key, value).apply()
    }

    fun putInt(name: String, key: String, value: Int) {
        getSharedPreferences(name).edit().putInt(key, value).apply()
    }

    fun putIntCommit(key: String, value: Int) {
        getSharedPreferences().edit().putInt(key, value).commit()
    }

    fun putIntCommit(name: String, key: String, value: Int) {
        getSharedPreferences(name).edit().putInt(key, value).commit()
    }

    fun getInt(key: String, defaultValue: Int): Int {
        return getSharedPreferences().getInt(key, defaultValue)
    }

    fun getInt(name: String, key: String, defaultValue: Int): Int {
        return getSharedPreferences(name).getInt(key, defaultValue)
    }

    /**
     * 保存Long
     *
     * @param key
     * @param value
     */
    fun putLong(key: String, value: Long?) {
        getSharedPreferences().edit().putLong(key, value!!).apply()
    }

    fun putLong(name: String, key: String, value: Long?) {
        getSharedPreferences(name).edit().putLong(key, value!!).apply()
    }

    fun putLongCommit(key: String, value: Long?) {
        getSharedPreferences().edit().putLong(key, value!!).commit()
    }

    fun putLongCommit(name: String, key: String, value: Long?) {
        getSharedPreferences(name).edit().putLong(key, value!!).commit()
    }

    fun getLong(key: String, defaultValue: Long?): Long? {
        return getSharedPreferences().getLong(key, defaultValue!!)
    }

    fun getLong(name: String, key: String, defaultValue: Long?): Long? {
        return getSharedPreferences(name).getLong(key, defaultValue!!)
    }

    /**
     * 保存Boolean
     *
     * @param key
     * @param value
     */
    fun putBoolean(key: String, value: Boolean) {
        getSharedPreferences().edit().putBoolean(key, value).apply()
    }

    fun putBoolean(name: String, key: String, value: Boolean) {
        getSharedPreferences(name).edit().putBoolean(key, value).apply()
    }

    fun putBooleanCommit(key: String, value: Boolean) {
        getSharedPreferences().edit().putBoolean(key, value).commit()
    }

    fun putBooleanCommit(name: String, key: String, value: Boolean) {
        getSharedPreferences(name).edit().putBoolean(key, value).commit()
    }

    fun getBoolean(key: String, defaultValue: Boolean): Boolean? {
        return getSharedPreferences().getBoolean(key, defaultValue)
    }

    fun getBoolean(name: String, key: String, defaultValue: Boolean): Boolean? {
        return getSharedPreferences(name).getBoolean(key, defaultValue)
    }

    /**
     * 保存Float
     *
     * @param key
     * @param value
     */
    fun putFloat(key: String, value: Float) {
        getSharedPreferences().edit().putFloat(key, value).apply()
    }

    fun putFloat(name: String, key: String, value: Float) {
        getSharedPreferences(name).edit().putFloat(key, value).apply()
    }

    fun putFloatCommit(key: String, value: Float) {
        getSharedPreferences().edit().putFloat(key, value).commit()
    }

    fun putFloatCommit(name: String, key: String, value: Float) {
        getSharedPreferences(name).edit().putFloat(key, value).commit()
    }

    fun getFolat(key: String, defaultValue: Float): Float? {
        return getSharedPreferences().getFloat(key, defaultValue)
    }

    fun getFolat(name: String, key: String, defaultValue: Float): Float? {
        return getSharedPreferences(name).getFloat(key, defaultValue)
    }

    /**
     * 清除数据
     */
    fun remove(key: String) {
        getSharedPreferences().edit().remove(key).apply()
    }

    fun remove(name: String, key: String) {
        getSharedPreferences(name).edit().remove(key).apply()
    }

    fun removeAll() {
        getSharedPreferences().edit().clear().apply()
    }

    fun removeAll(name: String) {
        getSharedPreferences(name).edit().clear().apply()
    }

    fun removeCommit(key: String) {
        getSharedPreferences().edit().remove(key).commit()
    }

    fun removeCommit(name: String, key: String) {
        getSharedPreferences(name).edit().remove(key).commit()
    }

    fun removeAllCommit() {
        getSharedPreferences().edit().clear().commit()
    }

    fun removeAllCommit(name: String) {
        getSharedPreferences(name).edit().clear().commit()
    }

    private fun getSharedPreferences(): SharedPreferences {
        return getSharedPreferences("default_sp_Name")
    }

    private fun getSharedPreferences(name: String): SharedPreferences {
        return mContext.getSharedPreferences(name, Context.MODE_PRIVATE)
    }


}