package rx.library.kit.activity

import android.app.Dialog
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.annotation.DrawableRes
import androidx.appcompat.app.ActionBar
import androidx.appcompat.app.AppCompatActivity
import rx.library.kit.R
import rx.library.kit.RxKit
import rx.library.kit.StatusBar
import rx.library.kit.StatusBarUtil
import rx.library.kit.loading.LoadingView
import rx.library.kit.util.DensityUtils
import rx.library.kit.util.RxDeviceInfo

open class BaseActionBarActivity : AppCompatActivity() {

    private lateinit var backView: ImageView

    private lateinit var menuView: LinearLayout
    private var loadingView: View? = null
    private var emptyView: View? = null
    private var loadingDialog: Dialog? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setCustomActionBar()
    }

    private fun setCustomActionBar() {
        val lp = ActionBar.LayoutParams(
            ActionBar.LayoutParams.MATCH_PARENT,
            ActionBar.LayoutParams.MATCH_PARENT,
            Gravity.CENTER
        )
        val mActionBarView = LayoutInflater.from(this).inflate(R.layout.kit_base_titlebar, null)
        val titleView = mActionBarView.findViewById<TextView>(R.id.base_text)
        titleView.text = getTitleText()

        titleView.setTextColor(getTitleTextColor())

        backView = mActionBarView.findViewById(R.id.base_back)
        backView.setImageDrawable(RxKit.getTitleBackIcon())
        backView.setOnClickListener { backHomeClick() }
        menuView = mActionBarView.findViewById(R.id.base_menu)

        val actionBar = supportActionBar
        actionBar!!.setBackgroundDrawable(ColorDrawable(RxKit.getTitleBackground()))
        actionBar.setCustomView(mActionBarView, lp)
        actionBar.displayOptions = ActionBar.DISPLAY_SHOW_CUSTOM
        actionBar.setDisplayShowCustomEnabled(true)
        actionBar.setDisplayShowHomeEnabled(true)
        actionBar.setDisplayShowTitleEnabled(false)
        StatusBar.setColor(this, RxKit.getTitleBackground(), 0)

    }

    /**
     * 返回上一层
     */
    open fun backHomeClick() {
        finish()
    }

    /**
     * 获取标题内容，可重新自定义设置标题文本内容
     */
    open fun getTitleText(): String {
        return title.toString()
    }

    /**
     * 获取标题颜色，可重新自定义设置标题文本颜色
     */
    open fun getTitleTextColor(): Int {
        return RxKit.getTitleTextColor()
    }

    fun setBackIcon(iconId: Int) {
        backView.setImageResource(iconId)
    }

    fun showLoadingDialog(show: Boolean) {
        if (loadingDialog == null) {
            loadingDialog = Dialog(this)
        }
        loadingDialog!!.window.setBackgroundDrawableResource(android.R.color.transparent)
        loadingDialog!!.window.setDimAmount(0f)
        loadingDialog!!.setCanceledOnTouchOutside(false)
        val loadingView = LoadingView(this)
        loadingView.setColor(RxKit.getLoadingDialogColor())
        loadingView.setSize(DensityUtils.dp2px(RxKit.getLoadingDialogSize()))
        loadingDialog!!.setContentView(loadingView)
        if (show) {
            if (!loadingDialog!!.isShowing) {
                loadingDialog!!.show()
            }
        } else {
            if (loadingDialog!!.isShowing) {
                loadingDialog!!.dismiss()
            }
        }
    }

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, onClickListener: View.OnClickListener) {
        addMenuItemTextView(text, getTitleTextColor(), onClickListener)
    }

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, color: Int, onClickListener: View.OnClickListener) {
        val view = LayoutInflater.from(this).inflate(R.layout.kit_menu_text, null) as TextView
        view.text = text
        val linearParams =
            LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.WRAP_CONTENT,
                LinearLayout.LayoutParams.MATCH_PARENT
            )
        linearParams.topMargin = 20
        linearParams.bottomMargin = 20
        view.setTextColor(color)
        view.layoutParams = linearParams
        view.setOnClickListener(onClickListener)
        menuView.addView(view)
    }

    /**
     * 添加一个图标菜单按钮
     */
    fun addMenuItemImageView(@DrawableRes resId: Int, onClickListener: View.OnClickListener) {
        val view = LayoutInflater.from(this).inflate(R.layout.kit_menu_image, null) as ImageView
        val linearParams =
            LinearLayout.LayoutParams(
                RxDeviceInfo.getNavigationBarHeight(),
                LinearLayout.LayoutParams.MATCH_PARENT
            )
        linearParams.topMargin = 20
        linearParams.bottomMargin = 20
        view.layoutParams = linearParams
        view.setImageResource(resId)
        view.setOnClickListener(onClickListener)
        menuView.addView(view)
    }

    fun getMenuItemImageView(position: Int): ImageView {
        return menuView.getChildAt(position) as ImageView
    }

    fun getMenuItemTextView(position: Int): TextView {
        return menuView.getChildAt(position) as TextView
    }

    /**
     * 设置状态栏白底黑字
     */
    fun setStatusBarLightMode() {
        StatusBarUtil.setStatusBarLightMode(this)
        StatusBar.setTranslucent(this)
        StatusBar.setColor(this, RxKit.getTitleBackground(), 0)
    }

    /**
     * 显示加载布局
     */
    fun showLoading(show: Boolean) {
        if (show) {
            if (loadingView == null) {
                loadingView = LayoutInflater.from(this).inflate(RxKit.getLoadingLayout(), null)
                getRootViewGroup().addView(loadingView)
            }
        } else {
            getRootViewGroup().removeView(loadingView)
            loadingView = null
        }
    }

    /**
     * 显示空布局
     */
    fun showEmpty(show: Boolean) {
        if (show) {
            if (emptyView == null) {
                emptyView = LayoutInflater.from(this).inflate(RxKit.getEmptyLayout(), null)
                getRootViewGroup().addView(emptyView)
            }
        } else {
            getRootViewGroup().removeView(emptyView)
            emptyView = null
        }
    }

    fun getRootViewGroup(): ViewGroup {
        return getRootView() as ViewGroup
    }

    fun getRootView(): View {
        return getWindow().getDecorView().findViewById(android.R.id.content)
    }
}