package rx.library.kit;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tencent.smtt.sdk.TbsReaderView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.library.kit.activity.BaseActionBarActivity;

import java.io.File;

public class OpenFileUtil extends BaseActionBarActivity {
    private TbsReaderView mTbsReaderView;
    private RelativeLayout layout;
    private String filePath;

    public static void open(Activity activity, String filePath) {
        open(activity, "查看文件", filePath);
    }

    public static void open(Activity activity, String title, String filePath) {
        Intent intent = new Intent(activity, OpenFileUtil.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        activity.startActivity(intent);
    }

    public static void open(Activity activity, String filePath, int requestCode) {
        open(activity, "查看文件", filePath, requestCode);
    }

    public static void open(Activity activity, String title, String filePath, int requestCode) {
        Intent intent = new Intent(activity, OpenFileUtil.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        activity.startActivityForResult(intent, requestCode);
    }

    @NotNull
    @Override
    public String getTitleText() {
        return getIntent().getStringExtra("title");
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.kit_activity_open_file);
        setStatusBarLightMode();
        filePath = getIntent().getStringExtra("filePath");
        layout = findViewById(R.id.kit_openFileLayout);
        mTbsReaderView = new TbsReaderView(this, null);
        layout.addView(mTbsReaderView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        bundle.putString("tempPath", new File(filePath).getParent());
        boolean result = mTbsReaderView.preOpen(parseFormat(new File(filePath).getName()), false);
        if (result) {
            mTbsReaderView.openFile(bundle);
        }
    }

    private String parseFormat(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            mTbsReaderView.onStop();
        } catch (Exception e) {
        }
    }
}
