package android.library.util.http;

import android.text.TextUtils;
import android.util.Log;
import okhttp3.Headers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Set;

public class HttpLogUtil {
    private static boolean mDebug;
    private static int mLogLevel;

    public static boolean isDebug() {
        return mDebug;
    }

    public static void setDebug(boolean debug, int logLevel) {
        mDebug = debug;
        mLogLevel = logLevel;
    }

    public static void log(HttpBuilder builder, HttpResponse response) {
        if (isDebug()) {
            String header = getHeader(builder.getHeaders());
            String params = getParams(builder.getParams());
            String url = "";
            try {
                url = URLDecoder.decode(response.getUrl(), "utf-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String data = response.getData();
            String method = response.getMethod();
            int code = response.getCode();
            String logStr = "\n" +
                    "----------------------- " + method + "  ---  " + code + " -----------------------" +
                    "\n接口地址：" + url +
                    "\n请求头：" + header +
                    "\n上传参数：" + params +
                    "\n返回数据：" + data;
            switch (mLogLevel) {
                case ApiInitialize.DEBUG:
                    Log.d("API接口", logStr);
                    break;
                case ApiInitialize.INFO:
                    Log.i("API接口", logStr);
                    break;
                default:
                    Log.e("API接口", logStr);
                    break;
            }
        }
    }

    private static String getHeader(Headers headers) {
        if (headers != null && headers.size() != 0) {
            String returnStr = "";
            Set<String> names = headers.names();
            for (String name : names) {
                String value = headers.get(name);
                String str = "\"" + name + "\":\"" + value + "\"";
                if (TextUtils.isEmpty(returnStr)) {
                    returnStr = str;
                } else {
                    returnStr = returnStr.concat(",".concat(str));
                }
            }
            return returnStr;
        } else {
            return "未设置请求头";
        }
    }


    private static String getParams(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return "未上传参数";
        } else {
            String returnStr = "";
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                String str = "\"" + key + "\":\"" + value + "\"";
                if (TextUtils.isEmpty(returnStr)) {
                    returnStr = str;
                } else {
                    returnStr = returnStr.concat(",".concat(str));
                }
            }
            return "{" + returnStr + "}";
        }

    }
}
