package android.library.util.http;

import okhttp3.OkHttpClient;

public class ApiInitialize {

    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int ERROR = 3;
    /**
     * 只能初始化一次,第二次将抛出异常
     */
    private static OkHttpClient mOkHttpClient;

    public static void init(OkHttpClient okHttpClient) {
        if (mOkHttpClient != null) {
            throw new IllegalArgumentException("OkHttpClient can only be initialized once");
        }
        mOkHttpClient = okHttpClient;
    }

    static OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = HttpSender.getDefaultOkHttpClient();
        }
        return mOkHttpClient;
    }

    public static void setDebug(boolean debug) {
        setDebug(debug, DEBUG);
    }

    public static void setDebug(boolean debug, int level) {
        HttpLogUtil.setDebug(debug, level);
    }

}
