package android.library.util.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.library.util.R;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import androidx.annotation.NonNull;

/**
 * @author lsm
 */
public class HintDialog extends Dialog {

    private TextView titleView;
    private TextView contentView;
    private TextView leftButtonView;
    private TextView rightButtonView;

    private Context context;
    private int gravity = Gravity.BOTTOM;
    private String titleStr = "提示";
    private String contentStr;
    private String leftButtonStr = "取消";
    private String rightButtonStr = "确定";
    private int animId = R.style.bottom_menu_animation;

    public HintDialog(@NonNull Context context, String content) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.contentStr = content;
    }

    public HintDialog(@NonNull Context context, int gravity, String content) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.gravity = gravity;
        this.contentStr = content;
    }

    public HintDialog(@NonNull Context context, String content, int animId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.contentStr = content;
        this.animId = animId;
    }

    public HintDialog(@NonNull Context context, int gravity, String content, int animId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.gravity = gravity;
        this.contentStr = content;
        this.animId = animId;
    }

    public HintDialog(@NonNull Context context, String content, String leftButton, String rightButton) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
    }

    public HintDialog(@NonNull Context context, int gravity, String content, String leftButton, String rightButton) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.gravity = gravity;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
    }

    public HintDialog(@NonNull Context context, String content, String leftButton, String rightButton, int animId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
        this.animId = animId;
    }

    public HintDialog(@NonNull Context context, int gravity, String content, String leftButton, String rightButton, int animId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.gravity = gravity;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
        this.animId = animId;
    }

    public HintDialog(@NonNull Context context, String title, String content, String leftButton, String rightButton) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.titleStr = title;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
    }

    public HintDialog(@NonNull Context context, int gravity, String title, String content, String leftButton, String rightButton) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.gravity = gravity;
        this.titleStr = title;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
    }

    public HintDialog(@NonNull Context context, String title, String content, String leftButton, String rightButton, int animId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.titleStr = title;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
        this.animId = animId;
    }

    public HintDialog(@NonNull Context context, int gravity, String title, String content, String leftButton, String rightButton, int animId) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.gravity = gravity;
        this.titleStr = title;
        this.contentStr = content;
        this.leftButtonStr = leftButton;
        this.rightButtonStr = rightButton;
        this.animId = animId;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(gravity);
        window.setWindowAnimations(animId);
        setContentView(R.layout.ui_dialog_hint);
        WindowManager manager = ((Activity) context).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels * 9 / 10;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);

        titleView = findViewById(R.id.uiDialogHint_title);
        contentView = findViewById(R.id.uiDialogHint_content);
        leftButtonView = findViewById(R.id.uiDialogHint_leftButton);
        rightButtonView = findViewById(R.id.uiDialogHint_rightButton);

        titleView.setText(titleStr);
        contentView.setText(contentStr);
        leftButtonView.setText(leftButtonStr);
        rightButtonView.setText(rightButtonStr);
        leftButtonView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setOnLeftClickListener();
            }
        });
        rightButtonView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setOnRightClickListener();
            }
        });
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public void setTitle(String title) {
        this.titleStr = title;
    }

    public void setContent(String content) {
        this.contentStr = content;
    }

    public void setLeftButton(String leftButton) {
        this.leftButtonStr = leftButton;
    }

    public void setRightButton(String rightButton) {
        this.rightButtonStr = rightButton;
    }

    public void setOnLeftClickListener() {
        dismiss();
    }

    public void setOnRightClickListener() {
        dismiss();
    }

}
