package rx.library.kit.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import rx.library.kit.R;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.NonNull;

/**
 * 底部弹出dialog，宽度为屏幕宽度十分之九
 * 实例化时传入布局id和布局中控件的id
 * 可通过setOnBottomMenuItemClickListener()方法实现对传入控件的点击事件监听
 */
public class BottomClickDialog extends Dialog implements View.OnClickListener {

    private Context context;
    private int layoutResID;

    /**
     * 要监听的控件id
     */
    private int[] listenedItems;

    private OnBottomMenuItemClickListener listener;

    public BottomClickDialog(@NonNull Context context, int layoutResID, int[] listenedItems) {
        super(context, R.style.kit_bottom_dialog_custom);
        this.context = context;
        this.layoutResID = layoutResID;
        this.listenedItems = listenedItems;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(Gravity.BOTTOM);
        window.setWindowAnimations(R.style.kit_bottom_menu_animation);
        setContentView(layoutResID);
        WindowManager manager = ((Activity) context).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels * 9 / 10;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);
        for (int id : listenedItems) {
            findViewById(id).setOnClickListener(this);
        }
    }


    public interface OnBottomMenuItemClickListener {
        void onBottomMenuItemClick(BottomClickDialog dialog, View view);

    }

    public void setOnBottomMenuItemClickListener(OnBottomMenuItemClickListener listener) {
        this.listener = listener;
    }

    @Override
    public void onClick(View view) {
        dismiss();
        listener.onBottomMenuItemClick(this, view);
    }

    @Override
    public void dismiss() {
        View view = getCurrentFocus();
        if (view instanceof TextView) {
            InputMethodManager mInputMethodManager = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
            mInputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.RESULT_UNCHANGED_SHOWN);
        }
        super.dismiss();
    }
}
