package rx.library.kit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;

import androidx.appcompat.widget.AppCompatTextView;

import rx.library.kit.R;

/**
 * 支持圆角、边框的TextView
 */
public class ShapeTextView extends AppCompatTextView {
    /**
     * corners
     */
    private float mRadius = 0;
    private float mTopLeftRadius = 0;
    private float mTopRightRadius = 0;
    private float mBottomLeftRadius = 0;
    private float mBottomRightRadius = 0;

    /**
     * stroke
     */
    private int mStrokeWidth = 0;
    private int mStrokeColor = 0;
    private int mStrokeDashWidth = 0;
    private int mStrokeDashGap = 0;

    /**
     * solid
     */
    private int mSolidColor = 0;

    public ShapeTextView(Context context) {
        this(context, null);
    }

    public ShapeTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.u_shapeTextView);
        /**
         * corners
         */
        mRadius = a.getDimensionPixelSize(R.styleable.u_shapeTextView_radius, 0);
        mTopLeftRadius = a.getDimensionPixelSize(R.styleable.u_shapeTextView_topLeftRadius, 0);
        mTopLeftRadius = a.getDimensionPixelSize(R.styleable.u_shapeTextView_topLeftRadius, 0);
        mTopRightRadius = a.getDimensionPixelSize(R.styleable.u_shapeTextView_topRightRadius, 0);
        mBottomLeftRadius = a.getDimensionPixelSize(R.styleable.u_shapeTextView_bottomLeftRadius, 0);
        mBottomRightRadius = a.getDimensionPixelSize(R.styleable.u_shapeTextView_bottomRightRadius, 0);
        /**
         * stroke
         */
        mStrokeWidth = a.getDimensionPixelSize(R.styleable.u_shapeTextView_strokeWidth, 0);
        mStrokeColor = a.getColor(R.styleable.u_shapeTextView_strokeColor, 0);
        mStrokeDashWidth = a.getDimensionPixelSize(R.styleable.u_shapeTextView_strokeDashWidth, 0);
        mStrokeDashGap = a.getDimensionPixelSize(R.styleable.u_shapeTextView_strokeDashGap, 0);
        /**
         * solid
         */
        mSolidColor = a.getColor(R.styleable.u_shapeTextView_solidColor, 0);

    }

    @SuppressLint("DrawAllocation")
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        GradientDrawable drawable = new GradientDrawable();
        if (mTopLeftRadius != 0 || mTopRightRadius != 0 || mBottomLeftRadius != 0 || mBottomRightRadius != 0) {
            drawable.setCornerRadii(new float[]{
                    mTopLeftRadius, mTopLeftRadius, mTopRightRadius, mTopRightRadius,
                    mBottomLeftRadius, mBottomLeftRadius, mBottomRightRadius, mBottomRightRadius});
        } else {
            if (mRadius != 0) {
                drawable.setCornerRadius(mRadius);
            }
        }
        if (mStrokeWidth != 0 || (mStrokeDashGap != 0 && mStrokeDashWidth != 0)) {
            drawable.setStroke(mStrokeWidth, mStrokeColor);
        }
        if (mSolidColor != 0) {
            drawable.setColor(mSolidColor);
        } else {
            drawable.setColor(Color.parseColor("#FFFFFF"));
        }
        setBackgroundDrawable(drawable);
    }

}
