package rx.library.kit.picker;

import java.util.ArrayList;
import java.util.List;

public class DirectoryBean {
    private String name;
    private List<PhotoBean> list;
    private boolean select;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addPhoto(PhotoBean bean) {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.add(bean);
    }

    public List<PhotoBean> getList() {
        if (list == null) {
            list = new ArrayList<>();
        }
        return list;
    }

    public void setList(List<PhotoBean> list) {
        this.list = list;
    }

    public boolean isSelect() {
        return select;
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public static class PhotoBean implements Comparable<PhotoBean> {
        /**
         * 本地路径
         */
        private String path;
        /**
         * 创建时间
         */
        private long createTime;
        /**
         * byte 字节
         */
        private long size;
        /**
         * 所属目录
         */
        private String directory;

        public String getDirectory() {
            return directory;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public long getCreateTime() {
            return createTime;
        }

        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public long getSize() {
            return size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        @Override
        public int compareTo(PhotoBean bean) {
            if (this.createTime == bean.getCreateTime()) {
                return 0;
            } else if (this.createTime > bean.getCreateTime()) {
                return -1;
            } else {
                return 1;
            }
        }
    }

}
