package rx.library.kit.http.response;

import com.alibaba.fastjson.JSON;

import java.util.List;

public class ApiSuccessResponse {
    private String url;
    private String data;
    private String method;
    private int code;

    public ApiSuccessResponse() {
    }

    public ApiSuccessResponse(String url, String data, String method, int code) {
        this.url = url;
        this.data = data;
        this.method = method;
        this.code = code;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public <T> T getData(Class<T> tClass) {
        return JSON.parseObject(data, tClass);
    }

    public <T> List<T> getList(Class<T> tClass) {
        return JSON.parseArray(data, tClass);
    }
//    public <T> ArrayList<T> getList(Class<T> tClass) {
//        return (ArrayList<T>) JSON.parseArray(data, tClass);
//    }
}
