package rx.library.kit.http.response;

import com.alibaba.fastjson.JSON;

import java.util.List;

public class ApiResponse {
    private String mUr;
    private String data;
    private String method;
    private int code;

    public ApiResponse() {
    }

    public ApiResponse(String url, String method) {
        this.mUr = url;
        this.method = method;
    }

    public ApiResponse(String mUr, String data, String method) {
        this.mUr = mUr;
        this.data = data;
        this.method = method;
    }

    public ApiResponse(String mUr, String data, String method, int code) {
        this.mUr = mUr;
        this.data = data;
        this.method = method;
        this.code = code;
    }

    public String getUrl() {
        return mUr;
    }

    public void setUrl(String url) {
        this.mUr = url;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isUrl(String url) {
        return url.equals(mUr);
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public <T> T getData(Class<T> tClass) {
        return JSON.parseObject(data, tClass);
    }

    public <T> List<T> getList(Class<T> tClass) {
        return JSON.parseArray(data, tClass);
    }

    @Override
    public String toString() {
        return "{" +
                "url='" + mUr + '\'' +
                ", data='" + data + '\'' +
                ", method='" + method + '\'' +
                ", code=" + code +
                '}';
    }

}
