package rx.library.kit.http.other;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class QXHttpResponse {
    private String url;
    private String data;
    private boolean success;
    private String method;
    private int code;

    public QXHttpResponse(String url, String data, boolean success, String method, int code) {
        this.url = url;
        this.data = data;
        this.success = success;
        this.method = method;
        this.code = code;
    }

    public String getUrl() {
        try {
            return URLDecoder.decode(url, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
