package rx.library.kit.http.builder;

import rx.library.kit.http.ApiDownloadCallBack;
import rx.library.kit.http.other.QXHttpBuildUtil;

public class DownloadBuilderHttp extends DownloadHttpBuilder {

    public DownloadBuilderHttp(String url) {
        super(url);
    }

    public static DownloadBuilderHttp with(String url) {
        return new DownloadBuilderHttp(url);
    }

    @Override
    public void builder(String path, ApiDownloadCallBack apiDownloadCallBack) {
        super.downloading(path, QXHttpBuildUtil.createDownloadRequest(DownloadBuilderHttp.this), apiDownloadCallBack);
    }
}
