package rx.library.kit.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import rx.library.kit.R;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.NonNull;

/**
 * 底部弹出dialog，宽度为屏幕宽度十分之九
 * 实例化时传入布局id
 */
public class BottomDialogById extends Dialog {

    private Context context;
    private int layoutId;

    public BottomDialogById(@NonNull Context context, int layoutId) {
        super(context, R.style.kit_bottom_dialog_custom);
        this.context = context;
        this.layoutId = layoutId;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(Gravity.BOTTOM);
        window.setWindowAnimations(R.style.kit_bottom_menu_animation);
        setContentView(layoutId);
        WindowManager manager = ((Activity) context).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels * 9 / 10;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);
    }

    @Override
    public void dismiss() {
        View view = getCurrentFocus();
        if (view instanceof TextView) {
            InputMethodManager mInputMethodManager = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
            mInputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.RESULT_UNCHANGED_SHOWN);
        }
        super.dismiss();
    }

}
