package rx.library.kit.retrofit;

import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

import java.util.concurrent.TimeUnit;

public abstract class RetrofitHelper {

    private OkHttpClient mOkHttpClient;
    private Retrofit mRetrofit;

    protected OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = new OkHttpClient().newBuilder()
                    //设置连接时间
                    .connectTimeout(getConnectTimeout(), TimeUnit.MILLISECONDS)
                    //设置读时间
                    .readTimeout(getReadTimeout(), TimeUnit.MILLISECONDS)
                    //设置写时间
                    .writeTimeout(getWriteTimeout(), TimeUnit.MILLISECONDS)
                    .build();
        }
        return mOkHttpClient;
    }

    protected final Retrofit getRetrofit() {
        if (mRetrofit == null) {
            mRetrofit = new Retrofit.Builder()
                    .baseUrl(getBaseUrl())
                    .addConverterFactory(getConverterFactory())
                    .addCallAdapterFactory(getCallAdapterFactory())
                    .client(getOkHttpClient()).build();
        }
        return mRetrofit;
    }

    protected Retrofit getRetrofit(String baseUrl) {
        return getRetrofit()
                .newBuilder()
                .baseUrl(baseUrl)
                .build();
    }

    protected long getConnectTimeout() {
        return 500;
    }

    protected long getReadTimeout() {
        return 500;
    }

    protected long getWriteTimeout() {
        return 1000;
    }

    /**
     * 获取数据解析适配器
     */
    protected abstract Converter.Factory getConverterFactory();

    /**
     * 获取RxJava支持
     */
    protected abstract CallAdapter.Factory getCallAdapterFactory();

    /**
     * 获取baseUrl
     *
     * @return
     */
    protected abstract String getBaseUrl();

    /**
     * 获取接口Class
     *
     * @return
     */
    protected abstract Class getServiceClass();
}
