package rx.library.kit.activity

import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageButton
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.annotation.DrawableRes
import androidx.appcompat.app.ActionBar
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import rx.library.kit.R
import rx.library.kit.RxKit
import rx.library.kit.StatusBar
import rx.library.kit.StatusBarUtil

open class BaseActionBarActivity : AppCompatActivity() {

    private lateinit var backView: ImageButton

    private lateinit var menuView: LinearLayout;
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setCustomActionBar()
    }

    private fun setCustomActionBar() {
        val lp = ActionBar.LayoutParams(
            ActionBar.LayoutParams.MATCH_PARENT,
            ActionBar.LayoutParams.MATCH_PARENT,
            Gravity.CENTER
        )
        val mActionBarView = LayoutInflater.from(this).inflate(R.layout.kit_base_titlebar, null)
        val titleView = mActionBarView.findViewById<TextView>(R.id.base_text)
        titleView.text = getTitleText()
        titleView.setTextColor(getTitleTextColor())
        backView = mActionBarView.findViewById(R.id.base_back)
        backView.setImageResource(RxKit.getTitleBackIcon())
        backView.setOnClickListener { finish() }
        menuView = mActionBarView.findViewById(R.id.base_menu)
        val actionBar = supportActionBar
        actionBar!!.setBackgroundDrawable(ColorDrawable(RxKit.getTitleBackground()))
        actionBar.setCustomView(mActionBarView, lp)
        actionBar.displayOptions = ActionBar.DISPLAY_SHOW_CUSTOM
        actionBar.setDisplayShowCustomEnabled(true)
        actionBar.setDisplayShowHomeEnabled(true)
        actionBar.setDisplayShowTitleEnabled(false)
        StatusBar.setColor(this, RxKit.getTitleBackground(), 0)

    }

    /**
     * 获取标题内容，可重新自定义设置标题文本内容
     */
    open fun getTitleText(): String {
        return title.toString()
    }

    /**
     * 获取标题颜色，可重新自定义设置标题文本颜色
     */
    open fun getTitleTextColor(): Int {
        return RxKit.getTitleTextColor()
    }

    fun setBackIcon(iconId: Int) {
        backView.setImageResource(iconId)
    }

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, onClickListener: View.OnClickListener) {
        addMenuItemTextView(text, getTitleTextColor(), onClickListener)
    }

    /**
     * 添加一个文字菜单按钮
     */
    fun addMenuItemTextView(text: String, color: Int, onClickListener: View.OnClickListener) {
        val view = TextView(this)
        view.textSize = 16f
        view.text = text
        view.gravity = Gravity.CENTER
        view.background = ContextCompat.getDrawable(this, R.drawable.kit_btn_bg_selector)
        val linearParams =
            LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.MATCH_PARENT)
        view.setPadding(20, 0, 20, 0)
        view.setTextColor(color)
        view.layoutParams = linearParams
        view.setOnClickListener(onClickListener)
        menuView.addView(view)

    }

    /**
     * 添加一个图标菜单按钮
     */
    fun addMenuItemImageView(@DrawableRes resId: Int, onClickListener: View.OnClickListener) {
        val view = ImageView(this)
        view.setImageResource(resId)
        view.background = ContextCompat.getDrawable(this, R.drawable.kit_btn_bg_selector)
        val linearParams =
            LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.MATCH_PARENT)
        view.setPadding(20, 0, 20, 0)
        view.layoutParams = linearParams
        view.setOnClickListener(onClickListener)
        menuView.addView(view)
    }

    /**
     * 设置状态栏白底黑字
     */
    fun setStatusBarLightMode() {
        StatusBarUtil.StatusBarLightMode(this)
        StatusBar.setTranslucent(this)
        StatusBar.setColor(this, RxKit.getTitleBackground(),0)
    }
}