package rx.library.kit

import android.content.Context
import android.graphics.Color
import rx.library.kit.util.RxLog

class RxKit {
    companion object {

        private lateinit var mContext: Context
        private var titleBackgroundColor: Int = Color.BLACK
        private var titleTextColor: Int = Color.BLACK
        private var backResId: Int = R.drawable.kit_arrow_back_black_24dp

        @JvmStatic
        fun init(context: Context) {
            mContext = context
        }

        @JvmStatic
        fun debug(open: Boolean) {
            RxLog.init(open)
        }

        @JvmStatic
        fun getContext(): Context = mContext

        /**
         * 初始化标题栏文本字体颜色
         */
        @JvmStatic
        fun initTitleTextColor(color: Int) {
            titleTextColor = color
        }

        /**
         * 获取标题栏文本字体颜色
         */
        @JvmStatic
        fun getTitleTextColor(): Int = titleTextColor

        /**
         * 初始化标题栏返回按钮图标
         */
        @JvmStatic
        fun initTitleBackIcon(resId: Int) {
            backResId = resId
        }

        /**
         * 获取标题栏返回按钮图标
         */
        @JvmStatic
        fun getTitleBackIcon(): Int = backResId

        /**
         * 设置状态栏标题栏背景颜色
         */
        @JvmStatic
        fun initTitleBackground(color: Int) {
            titleBackgroundColor = color
        }

        /**
         * 获取状态栏标题栏背景颜色
         */
        @JvmStatic
        fun getTitleBackground(): Int = titleBackgroundColor
    }
}