package android.library.util.http;

import android.library.util.http.builder.*;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class Api {

    /**
     * Get 请求
     */
    public static QXGetBuilderHttp get() {
        return get(null);
    }

    public static QXGetBuilderHttp get(String url) {
        return QXGetBuilderHttp.with(url);
    }

    /**
     * Post Form请求
     */
    public static QXPostFormBuilderHttp postForm() {
        return postForm(null);
    }

    public static QXPostFormBuilderHttp postForm(String url) {
        return QXPostFormBuilderHttp.with(url);
    }

    /**
     * Post JSON请求
     */
    public static QXPostJSONBuilderHttp postJSON() {
        return postJSON(null);
    }

    public static QXPostJSONBuilderHttp postJSON(String url) {
        return QXPostJSONBuilderHttp.with(url);
    }

    /**
     * Delete Form请求
     */
    public static QXDeleteFormBuilderHttp deleteForm() {
        return deleteForm(null);
    }

    public static QXDeleteFormBuilderHttp deleteForm(String url) {
        return QXDeleteFormBuilderHttp.with(url);
    }

    /**
     * Delete JSON请求
     */
    public static QXDeleteJSONBuilderHttp deleteJSON() {
        return deleteJSON(null);
    }

    public static QXDeleteJSONBuilderHttp deleteJSON(String url) {
        return QXDeleteJSONBuilderHttp.with(url);
    }

    /**
     * Put Form请求
     */
    public static QXPutFormBuilderHttp putForm() {
        return putForm(null);
    }

    public static QXPutFormBuilderHttp putForm(String url) {
        return QXPutFormBuilderHttp.with(url);
    }

    /**
     * Put JSON请求
     */
    public static QXPutJSONBuilderHttp putJSON() {
        return putJSON(null);
    }

    public static QXPutJSONBuilderHttp putJSON(String url) {
        return QXPutJSONBuilderHttp.with(url);
    }

    /**
     * GET 下载文件
     */
    public static QXDownloadBuilderHttp download() {
        return download(null);
    }

    public static QXDownloadBuilderHttp download(String url) {
        return QXDownloadBuilderHttp.with(url);
    }

    /**
     * 根据tag取消请求
     */
    public static void cancel(final Object tag) {
        OkHttpClient mOkHttpClient = ApiInitialize.getOkHttpClient();
        try {
            for (Call call : mOkHttpClient.dispatcher().queuedCalls()) {
                if (call.request().tag().toString().contains(tag.toString())) {
                    call.cancel();
                }
            }
            for (Call call : mOkHttpClient.dispatcher().runningCalls()) {
                if (call.request().tag().toString().contains(tag.toString())) {
                    call.cancel();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cancelDownload(final Object tag) {
        OkHttpClient mOkHttpClient = ApiInitialize.getDownloadOkHttpClient();
        if (mOkHttpClient != null) {
            try {
                for (Call call : mOkHttpClient.dispatcher().queuedCalls()) {
                    if (call.request().tag().toString().contains(tag.toString())) {
                        call.cancel();
                    }
                }
                for (Call call : mOkHttpClient.dispatcher().runningCalls()) {
                    if (call.request().tag().toString().contains(tag.toString())) {
                        call.cancel();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
