package android.library.util

import java.text.SimpleDateFormat
import java.util.*

/**
 * 时间格式化
 */
class TimeUtil private constructor() {

    companion object {
        private val YYYY_FORMAT = SimpleDateFormat("yyyy", Locale.getDefault())

        @JvmStatic
        fun todayYyyy(): String {
            return YYYY_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyy(date: Date): String {
            return YYYY_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyy(times: Long): String {
            return YYYY_FORMAT.format(Date(times))
        }

        private val YYYYMMDD_FORMAT = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())

        @JvmStatic
        fun todayYyyyMmDd(): String {
            return YYYYMMDD_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyyMmDd(date: Date): String {
            return YYYYMMDD_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyyMmDd(times: Long): String {
            return YYYYMMDD_FORMAT.format(Date(times))
        }

        private val YYYYMMDDHHMM_FORMAT = SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault())

        @JvmStatic
        fun todayYyyyMmDdHhMm(): String {
            return YYYYMMDDHHMM_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyyMmDdHhMm(date: Date): String {
            return YYYYMMDDHHMM_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyyMmDdHhMm(times: Long): String {
            return YYYYMMDDHHMM_FORMAT.format(Date(times))
        }


        private val YYYYMMDDHHMMSS_FORMAT = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())

        @JvmStatic
        fun todayYyyyMmDdHhMmSs(): String {
            return YYYYMMDDHHMMSS_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyyMmDdHhMmSs(date: Date): String {
            return YYYYMMDDHHMMSS_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyyMmDdHhMmSs(times: Long): String {
            return YYYYMMDDHHMMSS_FORMAT.format(Date(times))
        }


        private val HHMMSS_FORMAT = SimpleDateFormat("HH:mm:ss", Locale.getDefault())

        @JvmStatic
        fun todayHhMmSs(): String {
            return HHMMSS_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayHhMmSs(date: Date): String {
            return HHMMSS_FORMAT.format(date)
        }

        @JvmStatic
        fun todayHhMmSs(times: Long): String {
            return HHMMSS_FORMAT.format(Date(times))
        }
    }

}