package android.library.util.listview;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.GridView;

/**
 * 不可滚动的GridView，与ScrollView等滑动控件嵌套使用
 */
public class GridViewNoScroll extends GridView {

    public GridViewNoScroll(Context context) {
        super(context);
    }

    public GridViewNoScroll(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GridViewNoScroll(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = MeasureSpec.makeMeasureSpec(Integer.MAX_VALUE >> 2, MeasureSpec.AT_MOST);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }
}

