package android.library.util.recyclerview;

import android.view.View;

/**
 * recyclerView中item子控件的点击事件
 */
public class OnChildViewClickListener implements View.OnClickListener {
    private BaseViewAdapter.OnChildClickListener onChildClickListener;
    private int position;
    private int id;

    public OnChildViewClickListener(BaseViewAdapter.OnChildClickListener onChildClickListener, int position, int id) {
        if (this.onChildClickListener == null) {
            this.onChildClickListener = onChildClickListener;
        }
        this.position = position;
        this.id = id;
    }

    @Override
    public void onClick(View v) {
        if (onChildClickListener != null) {
            onChildClickListener.onChildClick(position, id);
        }
    }
}