package android.library.util.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.library.util.R;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.*;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import java.util.ArrayList;
import java.util.List;

/**
 * 底部弹出列表dialog，宽度等于屏幕宽度
 */
public class BottomListDialog extends Dialog implements AdapterView.OnItemClickListener {

    private Context mContext;
    private List<String> mList;
    private OnItemClickListener mOnItemClickListener;
    private boolean can = true;
    private int gravity = Gravity.CENTER;

    private BottomListDialog(@NonNull Context context) {
        super(context, R.style.bottom_dialog_custom);
        mContext = context;
        mList = new ArrayList<>();
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(Gravity.BOTTOM);
        window.setWindowAnimations(R.style.bottom_menu_animation);

        ListView listView = new ListView(getContext());
        listView.setDivider(new ColorDrawable(ContextCompat.getColor(mContext, R.color.dividerColor)));
        listView.setDividerHeight(1);
        listView.setBackgroundColor(Color.WHITE);
        ListDialogAdapter adapter = new ListDialogAdapter(mList);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(this);
        setContentView(listView);
        WindowManager manager = ((Activity) mContext).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);
    }

    public static BottomListDialog getInstance(Context context) {
        BottomListDialog bottomListDialog = new BottomListDialog(context);
        return bottomListDialog;
    }

    public BottomListDialog setTextGravity() {
        return this;
    }

    public BottomListDialog canCancel(boolean can) {
        this.can = can;
        return this;
    }

    public BottomListDialog addItem(List<String> list) {
        list.addAll(list);
        return this;
    }

    public BottomListDialog addItem(String text) {
        mList.add(text);
        return this;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        if (mOnItemClickListener != null) {
            mOnItemClickListener.onClick(this, position, mList.get(position));
            if (can) {
                cancel();
            }
        }
    }

    public interface OnItemClickListener {
        void onClick(@NonNull BottomListDialog dialog, int position, String text);
    }

    private class ListDialogAdapter extends BaseAdapter {
        private List<String> mList;

        public ListDialogAdapter(List<String> mList) {
            this.mList = mList;
        }

        @Override
        public int getCount() {
            return BottomListDialog.this.mList.size();
        }

        @Override
        public String getItem(int position) {
            return mList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder ho = null;
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(R.layout.ui_item_list_dialog, null);
                ho = new ViewHolder(convertView);
                convertView.setTag(ho);
            } else {
                ho = (ViewHolder) convertView.getTag();
            }
            ho.textView.setText(getItem(position));
            ho.textView.setGravity(gravity);
            return convertView;
        }

        class ViewHolder {
            private TextView textView;

            public ViewHolder(@NonNull View itemView) {
                textView = itemView.findViewById(R.id.uiItemListDialog_text);
            }
        }
    }

    public BottomListDialog show(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
        show();
        return this;
    }
}
